/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.upload;

import cn.wandersnail.common.http.upload.FileInfo;
import cn.wandersnail.common.http.upload.UploadInfo;
import cn.wandersnail.common.http.upload.UploadListener;
import cn.wandersnail.common.http.upload.UploadWorker;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Converter;

public class UploadWorkerBuilder<T> {
    private Converter<ResponseBody, T> converter;
    private Map<String, String> paramParts;
    private OkHttpClient client;
    private Map<String, String> headers;
    private List<FileInfo> fileInfos;
    private String tag;
    private String url;
    private UploadListener<T> listener;

    public UploadWorkerBuilder<T> setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public UploadWorkerBuilder<T> setUrl(String url) {
        this.url = url;
        return this;
    }

    public UploadWorkerBuilder<T> setListener(UploadListener<T> listener) {
        this.listener = listener;
        return this;
    }

    public UploadWorkerBuilder<T> setFileParts(List<FileInfo> fileInfos) {
        this.fileInfos = fileInfos;
        return this;
    }

    public UploadWorkerBuilder<T> setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public UploadWorkerBuilder<T> setConverter(Converter<ResponseBody, T> converter) {
        this.converter = converter;
        return this;
    }

    public UploadWorkerBuilder<T> setParamParts(Map<String, String> paramParts) {
        this.paramParts = paramParts;
        return this;
    }

    public UploadWorkerBuilder<T> setClient(OkHttpClient client) {
        this.client = client;
        return this;
    }

    public UploadWorker<T> build() {
        UploadInfo info = this.tag == null || this.tag.length() == 0 ? new UploadInfo(this.url) : new UploadInfo(this.tag, this.url);
        info.setClient(this.client).setConverter(this.converter).setFileParts(this.fileInfos).setHeaders(this.headers).setParamParts(this.paramParts);
        return new UploadWorker(info, this.listener);
    }
}

