/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http;

import cn.wandersnail.common.http.Configuration;
import cn.wandersnail.common.http.ConvertedResponse;
import cn.wandersnail.common.http.GeneralRequestTask;
import cn.wandersnail.common.http.HttpService;
import cn.wandersnail.common.http.SyncGeneralRequestTask;
import cn.wandersnail.common.http.callback.RequestCallback;
import cn.wandersnail.common.http.util.HttpUtils;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

abstract class Requester<T> {
    protected Configuration configuration;
    protected String url;
    protected Converter<ResponseBody, T> converter;

    Requester() {
    }

    public abstract ConvertedResponse<T> execute();

    public abstract Disposable enqueue(RequestCallback<T> var1);

    protected void handleConfiguration(String url, Configuration configuration) {
        Configuration config;
        String baseUrl = HttpUtils.getBaseUrl(url);
        Configuration configuration2 = config = configuration == null ? new Configuration() : configuration;
        if (config.retrofit == null) {
            int timeout = config.callTimeout > 0 ? config.callTimeout : 5;
            OkHttpClient client = HttpUtils.initHttpsClient(config.bypassAuth, new OkHttpClient.Builder()).readTimeout((long)timeout, TimeUnit.SECONDS).connectTimeout((long)timeout, TimeUnit.SECONDS).build();
            config.retrofit = new Retrofit.Builder().baseUrl(baseUrl).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(client).build();
        }
        config.service = (HttpService)config.retrofit.create(HttpService.class);
        this.configuration = config;
    }

    protected ConvertedResponse<T> execute(Call<ResponseBody> call) {
        return new SyncGeneralRequestTask<T>(call, this.converter, (Configuration)this.configuration).convertedResp;
    }

    protected Disposable enqueue(Observable<Response<ResponseBody>> observable, RequestCallback<T> callback) {
        return new GeneralRequestTask<T>(observable, this.converter, (Configuration)this.configuration, callback).disposable;
    }
}

