/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.converter;

import cn.wandersnail.common.http.EasyHttp;
import cn.wandersnail.common.http.callback.JsonParser;
import cn.wandersnail.common.http.converter.JsonParserType;
import cn.wandersnail.common.http.exception.ConvertException;
import com.alibaba.fastjson2.JSON;
import okhttp3.ResponseBody;
import retrofit2.Converter;

public class JsonResponseConverter<T>
implements Converter<ResponseBody, T> {
    private final Class<T> cls;
    private final JsonParser<T> parser;
    private JsonParserType parserType = JsonParserType.FASTJSON2;

    public JsonResponseConverter(Class<T> cls) {
        this.cls = cls;
        this.parser = null;
    }

    public JsonResponseConverter(Class<T> cls, JsonParserType parserType) {
        this.cls = cls;
        this.parserType = parserType;
        this.parser = null;
    }

    public JsonResponseConverter(JsonParser<T> parser) {
        this.parser = parser;
        this.cls = null;
    }

    public T convert(ResponseBody value) throws ConvertException {
        try {
            if (this.parser != null) {
                return this.parser.parse(value.string());
            }
            if (this.parserType == JsonParserType.FASTJSON2 && this.isFastjson2Supported()) {
                return (T)JSON.parseObject((String)value.string(), this.cls);
            }
            if (this.parserType == JsonParserType.FASTJSON && this.isFastjsonSupported()) {
                return (T)com.alibaba.fastjson.JSON.parseObject((String)value.string(), this.cls);
            }
            if (this.parserType == JsonParserType.GSON && this.isGsonSupported()) {
                return (T)EasyHttp.getGson().fromJson(value.string(), this.cls);
            }
            throw new ConvertException("\u6ca1\u6709\u53ef\u7528\u7684Body\u8f6c\u6362\u5668");
        }
        catch (Throwable e) {
            throw new ConvertException(e.getMessage(), e);
        }
    }

    private boolean isFastjsonSupported() {
        try {
            Class.forName("com.alibaba.fastjson.JSON");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private boolean isFastjson2Supported() {
        try {
            Class.forName("com.alibaba.fastjson2.JSON");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private boolean isGsonSupported() {
        try {
            Class.forName("com.google.gson.Gson");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

