/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.download;

import cn.wandersnail.common.http.TaskInfo;
import java.io.File;
import java.util.Objects;
import java.util.UUID;

public class DownloadInfo
extends TaskInfo {
    public final String savePath;
    long contentLength;
    long completionLength;
    private final String tempFilename;

    public DownloadInfo(String url, String savePath) {
        this(UUID.randomUUID().toString(), url, savePath);
    }

    public DownloadInfo(String tag, String url, String savePath) {
        super(tag, url);
        this.savePath = savePath;
        this.tempFilename = UUID.randomUUID().toString();
    }

    public long getCompletionLength() {
        return this.completionLength;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public File getTemporaryFile() {
        return new File(System.getProperty("java.io.tmpdir"), this.tempFilename);
    }

    @Override
    public void reset() {
        this.completionLength = 0L;
        this.contentLength = 0L;
        this.getTemporaryFile().delete();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadInfo)) {
            return false;
        }
        DownloadInfo that = (DownloadInfo)o;
        return this.savePath.equals(that.savePath) && this.url.equals(that.url);
    }

    public int hashCode() {
        return Objects.hash(this.savePath, this.url);
    }
}

