/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.download;

import cn.wandersnail.common.http.download.DownloadInfo;
import cn.wandersnail.common.http.download.DownloadWorker;
import cn.wandersnail.common.http.download.MultiDownloadListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MultiDownloadWorkerBuilder {
    private final List<DownloadInfo> infoList = new ArrayList<DownloadInfo>();
    private MultiDownloadListener<DownloadInfo> listener;

    public MultiDownloadWorkerBuilder addFileInfo(String url, String savePath) {
        return this.addFileInfo(UUID.randomUUID().toString(), url, savePath);
    }

    public MultiDownloadWorkerBuilder addFileInfo(String tag, String url, String savePath) {
        DownloadInfo info = new DownloadInfo(tag, url, savePath);
        if (!this.infoList.contains(info)) {
            this.infoList.add(info);
        }
        return this;
    }

    public MultiDownloadWorkerBuilder setListener(MultiDownloadListener<DownloadInfo> listener) {
        this.listener = listener;
        return this;
    }

    public DownloadWorker<DownloadInfo> build() {
        return new DownloadWorker<DownloadInfo>(this.infoList, this.listener);
    }
}

