/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.download;

import cn.wandersnail.common.http.callback.ProgressListener;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody responseBody;
    private final ProgressListener listener;
    private BufferedSource bufferedSource;

    ProgressResponseBody(ResponseBody responseBody, ProgressListener listener) {
        this.responseBody = responseBody;
        this.listener = listener;
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            private long totalReadBytes;

            public long read(Buffer sink, long byteCount) throws IOException {
                long readBytes = super.read(sink, byteCount);
                this.totalReadBytes += readBytes != -1L ? readBytes : 0L;
                if (this.totalReadBytes > 0L && ProgressResponseBody.this.contentLength() > 0L && ProgressResponseBody.this.listener != null) {
                    ProgressResponseBody.this.listener.onProgress(this.totalReadBytes, ProgressResponseBody.this.responseBody.contentLength());
                }
                return readBytes;
            }
        };
    }
}

