/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.exception;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RetryWhenException
implements Function<Observable<Throwable>, Observable<?>> {
    private int count;
    private int delay;
    private int increaseDelay;

    public RetryWhenException() {
        this(3, 3000, 3000);
    }

    public RetryWhenException(int count) {
        this(count, 3000, 3000);
    }

    public RetryWhenException(int count, int delay) {
        this(count, delay, 3000);
    }

    public RetryWhenException(int count, int delay, int increaseDelay) {
        this.count = count;
        this.delay = delay;
        this.increaseDelay = increaseDelay;
    }

    public Observable<?> apply(Observable<Throwable> observable) throws Exception {
        return observable.zipWith((ObservableSource)Observable.range((int)1, (int)(this.count + 1)), (BiFunction)new BiFunction<Throwable, Integer, Wrapper>(){

            public Wrapper apply(Throwable throwable, Integer index) throws Exception {
                return new Wrapper(throwable, index);
            }
        }).flatMap(new Function<Wrapper, ObservableSource<?>>(){

            public ObservableSource<?> apply(Wrapper wrapper) throws Exception {
                if (wrapper.throwable instanceof ConnectException || wrapper.throwable instanceof SocketTimeoutException || wrapper.throwable instanceof TimeoutException) {
                    return Observable.timer((long)(RetryWhenException.this.delay + (wrapper.index - 1) * RetryWhenException.this.increaseDelay), (TimeUnit)TimeUnit.MILLISECONDS);
                }
                return Observable.error((Throwable)wrapper.throwable);
            }
        });
    }

    private class Wrapper {
        Throwable throwable;
        int index;

        Wrapper(Throwable throwable, int index) {
            this.throwable = throwable;
            this.index = index;
        }
    }
}

