/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.upload;

import cn.wandersnail.common.http.upload.FileInfo;
import cn.wandersnail.common.http.upload.SyncUploadWorker;
import cn.wandersnail.common.http.upload.UploadInfo;
import cn.wandersnail.common.http.upload.UploadProgressListener;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Converter;

public class SyncUploadWorkerBuilder<T> {
    private Converter<ResponseBody, T> converter;
    private Map<String, String> paramParts;
    private OkHttpClient client;
    private Map<String, String> headers;
    private List<FileInfo> fileInfos;
    private String tag;
    private String url;
    private UploadProgressListener listener;

    public SyncUploadWorkerBuilder<T> setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public SyncUploadWorkerBuilder<T> setUrl(String url) {
        this.url = url;
        return this;
    }

    public SyncUploadWorkerBuilder<T> setListener(UploadProgressListener listener) {
        this.listener = listener;
        return this;
    }

    public SyncUploadWorkerBuilder<T> setFileParts(List<FileInfo> fileInfos) {
        this.fileInfos = fileInfos;
        return this;
    }

    public SyncUploadWorkerBuilder<T> setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public SyncUploadWorkerBuilder<T> setConverter(Converter<ResponseBody, T> converter) {
        this.converter = converter;
        return this;
    }

    public SyncUploadWorkerBuilder<T> setParamParts(Map<String, String> paramParts) {
        this.paramParts = paramParts;
        return this;
    }

    public SyncUploadWorkerBuilder<T> setClient(OkHttpClient client) {
        this.client = client;
        return this;
    }

    public SyncUploadWorker<T> build() {
        UploadInfo info = this.tag == null || this.tag.length() == 0 ? new UploadInfo(this.url) : new UploadInfo(this.tag, this.url);
        info.setClient(this.client).setConverter(this.converter).setFileParts(this.fileInfos).setHeaders(this.headers).setParamParts(this.paramParts);
        return new SyncUploadWorker(info, this.listener);
    }
}

