/*
 * Decompiled with CFR 0.152.
 */
package cn.wandersnail.common.http.upload;

import cn.wandersnail.common.http.upload.FileInfo;
import cn.wandersnail.common.http.upload.ProgressRequestBody;
import cn.wandersnail.common.http.upload.UploadInfo;
import cn.wandersnail.common.http.upload.UploadListener;
import cn.wandersnail.common.http.upload.UploadObserver;
import cn.wandersnail.common.http.upload.UploadService;
import cn.wandersnail.common.http.util.HttpUtils;
import cn.wandersnail.common.http.util.SchedulerUtils;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class UploadWorker<T>
implements Disposable {
    private final UploadObserver<T> observer;

    public UploadWorker(UploadInfo<T> info, UploadListener<T> listener) {
        this.observer = new UploadObserver<T>(info, listener);
        Retrofit.Builder builder = new Retrofit.Builder();
        if (info.client != null) {
            builder.client(HttpUtils.initHttpsClient(true, new OkHttpClient.Builder()).build());
        }
        UploadService service = (UploadService)builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(info.getBaseUrl()).build().create(UploadService.class);
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        if (info.paramParts != null) {
            for (Map.Entry entry : info.paramParts.entrySet()) {
                bodyBuilder.addFormDataPart((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (FileInfo fileInfo : info.fileInfos) {
            try {
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)fileInfo.getFromDataName(), (String)URLEncoder.encode(fileInfo.getFilename(), "utf-8"), (RequestBody)new ProgressRequestBody(MediaType.parse((String)"multipart/form-data"), fileInfo.getFilename(), fileInfo.getInputStream(), this.observer));
                bodyBuilder.addPart(part);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        Observable<Response<ResponseBody>> observable = info.headers == null || info.headers.isEmpty() ? service.upload(info.url, bodyBuilder.build()) : service.upload(info.url, bodyBuilder.build(), info.headers);
        observable.compose(SchedulerUtils.applyGeneralObservableSchedulers()).subscribe(this.observer);
    }

    public void dispose() {
        this.observer.dispose();
    }

    public boolean isDisposed() {
        return this.observer.isDisposed();
    }

    public void cancel() {
        this.dispose();
    }
}

