package co.cloudcraft;

import lombok.*;

@Builder
@Getter
@EqualsAndHashCode
@ToString
public class ClientConfig {
  private static final long serialVersionUID = 2L;
  public static final String DEFAULT_PROTOCOL = "https";
  public static final String DEFAULT_HOST = "api.cloudcraft.co";
  public static final String DEFAULT_BASE_PATH = "";
  public static final int DEFAULT_PORT = 443;
  public static final int DEFAULT_TIMEOUT_MS = 80000;
  public static final int DEFAULT_MAX_NETWORK_RETRIES = 10;

  private String protocol;
  private String host;
  private Integer port;
  private Integer readTimeout;
  private Integer maxRetries;
}
