package co.cloudcraft.api;

import co.cloudcraft.RestClient;
import co.cloudcraft.exception.CloudcraftException;
import co.cloudcraft.model.CloudcraftObject;
import co.cloudcraft.model.CloudcraftResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHeaders;

public abstract class ApiBase {
  protected final RestClient restClient;

  protected static final Map<String, String> CONTENT_TYPE_HEADER_MAP = new HashMap<>();

  static {
    CONTENT_TYPE_HEADER_MAP.put(
        HttpHeaders.CONTENT_TYPE, ContentType.APPLICATION_JSON.getMimeType());
  }

  public ApiBase(RestClient restClient) {
    this.restClient = restClient;
  }

  <T> T parseCloudcraftResponse(CloudcraftResponse response, Class<T> clazz)
      throws CloudcraftException {
    int statusCode = response.getStatusCode();

    if (statusCode == 204 && clazz.equals(Void.class)) {
      return null;
    }

    T ccResponse = CloudcraftObject.GSON.fromJson(response.getResponseAsString(), clazz);
    if (ccResponse instanceof CloudcraftObject) {
      ((CloudcraftObject) ccResponse).setETag(response.getETag());
    }
    return ccResponse;
  }

  public enum BudgetExportFormat {
    CSV("csv"),
    XLSX("xlsx");
    private final String format;

    BudgetExportFormat(String f) {
      this.format = f;
    }

    @Override
    public String toString() {
      return this.format;
    }
  }

  public enum BlueprintExportFormat {
    SVG("svg"),
    PDF("pdf"),
    PNG("png"),
    MX_GRAPH("mxGraph"),
    JSON("json");
    private final String format;

    BlueprintExportFormat(String f) {
      this.format = f;
    }

    @Override
    public String toString() {
      return this.format;
    }
  }
}
