package co.cloudcraft.api;

import co.cloudcraft.RestClient;
import co.cloudcraft.exception.CloudcraftException;
import co.cloudcraft.model.CloudcraftResponse;
import co.cloudcraft.model.ExportBudgetQueryParams;
import java.util.Map;
import lombok.NonNull;
import org.apache.hc.core5.http.Method;

public class BudgetApi extends ApiBase {
  public BudgetApi(RestClient restClient) {
    super(restClient);
  }

  /**
   * Export budget for blueprint in CSV or XLSX format. Consumer of this API can extract the
   * response using the convenience APIs in <code>CloudcraftResponse</code> either in <code>String
   * </code> or <code>byte[]</code> format.
   *
   * @param blueprintId blueprint identifier
   * @param format one of CSV or XLSX format
   * @param requestParams Optional query parameters for the configuring the response
   * @return Response object
   * @throws CloudcraftException when any error occurs exercising this API
   */
  public CloudcraftResponse export(
      @NonNull String blueprintId,
      @NonNull BudgetExportFormat format,
      ExportBudgetQueryParams requestParams)
      throws CloudcraftException {
    Map<String, String> paramsMap = requestParams != null ? requestParams.toMap() : null;

    return restClient.execute(
        Method.GET, String.format("/blueprint/%s/budget/%s", blueprintId, format), paramsMap);
  }
}
