package co.cloudcraft.api;

import co.cloudcraft.RestClient;
import co.cloudcraft.exception.CloudcraftException;
import co.cloudcraft.model.CloudcraftResponse;
import co.cloudcraft.model.User;
import org.apache.hc.core5.http.Method;

public class UserApi extends ApiBase {

  public UserApi(RestClient restClient) {
    super(restClient);
  }

  /**
   * Retrieve your own user profile.
   *
   * @return requesting user's profile in Cloudcraft
   * @throws CloudcraftException when any error occurs exercising this API
   */
  public User getMyInfo() throws CloudcraftException {
    CloudcraftResponse response = restClient.execute(Method.GET, "/user/me");
    return parseCloudcraftResponse(response, User.class);
  }
}
