package co.cloudcraft.exception;

import lombok.Getter;

/**
 * The class CloudcraftException and its subclasses are a form of Throwable that indicates
 * conditions that a reasonable application might want to catch.
 */
@Getter
public class CloudcraftException extends Exception {
  private static final long serialVersionUID = 2L;
  private final String code;
  private final Integer statusCode;

  public CloudcraftException(ErrorResponse error, Integer statusCode) {
    this(error.getError(), String.valueOf(error.getCode()), statusCode);
  }

  public CloudcraftException(String message, String code) {
    this(message, code, null, null);
  }

  public CloudcraftException(String message, String code, Integer statusCode) {
    this(message, code, statusCode, null);
  }

  public CloudcraftException(String message, String code, Integer statusCode, Throwable e) {
    super(message, e);
    this.code = code != null ? code : statusCode.toString();
    this.statusCode = statusCode;
  }

  @Override
  public String getMessage() {
    String additionalInfo = "";
    if (code != null) {
      additionalInfo += "; statusCode: " + statusCode;
    }
    return super.getMessage() + additionalInfo;
  }
}
