package co.cloudcraft.model;

import lombok.*;

/** Object representing a Blueprint in Cloudcraft */
@Getter
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class Blueprint extends BlueprintMetadata {
  /** Blueprint data */
  private final BlueprintData data;

  public Blueprint(
      String id,
      String[] tags,
      String[] readAccess,
      String[] writeAccess,
      String createdAt,
      String updatedAt,
      String creatorId,
      String lastUserID,
      BlueprintData data) {
    super(
        id,
        data.getName(),
        tags,
        readAccess,
        writeAccess,
        createdAt,
        updatedAt,
        creatorId,
        lastUserID);
    this.data = data;
  }

  @Override
  public String getName() {
    return (super.getName() != null) ? super.getName() : (data != null) ? data.getName() : null;
  }
}
