package co.cloudcraft.model;

import java.util.List;
import lombok.*;

@Builder
@Getter
@EqualsAndHashCode(callSuper = false)
@ToString
public class BlueprintData extends CloudcraftObject {
  private final String grid;
  private final String name;
  private final List<Object> text;
  private final List<Object> edges;
  private final List<Object> icons;
  private final List<Object> nodes;
  private final Object theme;
  private final List<Object> groups;
  private final List<Object> images;
  private final Integer version;
  private final List<Object> surfaces;
  private final boolean shareDocs;
  private final List<Object> connectors;
  private final String projection;
  private final Object liveAccount;
  private final Object liveOptions;
  private final List<String> disabledLayers;

  /**
   * Utility method to create a <code>BlueprintDataBuilder</code> that is pre-populated with data
   * from the given blueprint.
   *
   * @param bp Blueprint to pre-populate the builder
   * @return pre-populated builder.
   */
  public static BlueprintDataBuilder builderFrom(@NonNull BlueprintData bp) {
    return BlueprintData.builder()
        .grid(bp.grid)
        .name(bp.name)
        .text(bp.text)
        .edges(bp.edges)
        .icons(bp.icons)
        .nodes(bp.nodes)
        .theme(bp.theme)
        .groups(bp.groups)
        .images(bp.images)
        .version(bp.version)
        .surfaces(bp.surfaces)
        .shareDocs(bp.shareDocs)
        .connectors(bp.connectors)
        .projection(bp.projection)
        .liveAccount(bp.liveAccount)
        .liveOptions(bp.liveOptions)
        .disabledLayers(bp.disabledLayers);
  }
}
