package co.cloudcraft.model;

import com.google.gson.annotations.SerializedName;
import lombok.*;

@RequiredArgsConstructor
@Getter
@EqualsAndHashCode(callSuper = false)
@ToString
public class BlueprintMetadata extends CloudcraftObject {
  /** Cloudcraft issued unique identifier. */
  protected final String id;

  /** Name assigned to the blueprint */
  protected final String name;

  /** Tags assigned to group and organize blueprints */
  protected final String[] tags;

  /** List of teams or customers with read access. */
  private final String[] readAccess;

  /** List of teams or customers with write access. */
  private final String[] writeAccess;

  @Getter(AccessLevel.NONE)
  protected final String createdAt;

  @Getter(AccessLevel.NONE)
  protected final String updatedAt;

  /** Creator of the blueprint. */
  @SerializedName("CreatorId")
  protected final String creatorId;

  /** User that last updated the blueprint. */
  @SerializedName("LastUserId")
  protected final String lastUserId;

  /**
   * Returns when the user account was last updated.
   *
   * @return updated time in milliseconds since epoch.
   */
  public Long getCreatedTime() {
    return convertDateStringToInstant(this.createdAt);
  }

  /**
   * Returns when the user last access Cloudcraft.
   *
   * @return last accessed time in milliseconds since epoch.
   */
  public Long getUpdatedTime() {
    return convertDateStringToInstant(this.updatedAt);
  }
}
