package co.cloudcraft.model;

import lombok.*;

/** Request object representing the inputs required to create / update a Blueprint. */
@NoArgsConstructor
@RequiredArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ToString
public class BlueprintRequest extends CloudcraftObject {
  /** Blueprint data */
  @NonNull private BlueprintData data;

  /** List of teams or customers with read access. */
  private String[] readAccess;

  /** List of teams or customers with write access. */
  private String[] writeAccess;
}
