package co.cloudcraft.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import lombok.Getter;
import lombok.Setter;

/** Base class for all data models. */
public abstract class CloudcraftObject {
  protected static final long serialVersionUID = 2L;

  @Setter @Getter protected String eTag;

  public static final Gson PRETTY_PRINT_GSON =
      new GsonBuilder().setPrettyPrinting().serializeNulls().create();

  public static final Gson GSON = new GsonBuilder().create();

  public String prettyPrint() {
    return String.format("%s", PRETTY_PRINT_GSON.toJson(this));
  }

  public String toJson() {
    return GSON.toJson(this);
  }

  protected Long convertDateStringToInstant(String dateAsString) {
    if (dateAsString == null) return null;

    return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(dateAsString)).toEpochMilli();
  }
}
