package co.cloudcraft.model;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Builder(builderMethodName = "exportParamsBuilder")
@EqualsAndHashCode(callSuper = false)
@ToString
public class ExportBlueprintQueryParams {
  /** Scale relative to original size (1.0), for example 0.5 for half or 2.0 for double size. */
  private Float scale;

  /** Image width in pixels (for SVG, PNG and PDF). */
  private Integer width;

  /** Image height in pixels (for SVG, PNG and PDF). */
  private Integer height;

  /** Enable or disable grid rendering */
  private Boolean grid;

  /** Enable or disable transparent background rendering. */
  private Boolean transparent;

  /** Enable or disable landscape paper format (PDF). */
  private Boolean landscape;

  /** Paper size for rendering */
  private PaperSize paperSize;

  public Map<String, String> toMap() {
    String js = CloudcraftObject.GSON.toJson(this);
    Type exportBlueprintRequestType = new TypeToken<Map<String, String>>() {}.getType();
    return CloudcraftObject.GSON.fromJson(js, exportBlueprintRequestType);
  }

  public enum PaperSize {
    LETTER("Letter"),
    LEGAL("Legal"),
    TABLOID("Tabloid"),
    LEDGER("Ledger"),
    A0("A0"),
    A1("A1"),
    A2("A2"),
    A3("A3"),
    A4("A4"),
    A5("A5");

    private final String paperSize;

    PaperSize(String p) {
      this.paperSize = p;
    }

    @Override
    public String toString() {
      return this.paperSize;
    }
  }
}
