package co.cloudcraft.model;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Builder
@EqualsAndHashCode(callSuper = false)
@ToString
public class ExportBudgetQueryParams {
  /** Currency in ISO_4217 format. If none provided, response will be based on USD. */
  private final Currency currency;

  /** Period for budget. If none provided, response will be for monthly. */
  private final Period period;

  /** Should be one of "effective" (includes upfront fees) or "stated" (excludes upfront fees). */
  private final Rate rate;

  public Map<String, String> toMap() {
    String js = CloudcraftObject.GSON.toJson(this);
    Type exportBlueprintRequestType = new TypeToken<Map<String, String>>() {}.getType();
    return CloudcraftObject.GSON.fromJson(js, exportBlueprintRequestType);
  }

  public enum Rate {
    STATED("stated"),
    EFFECTIVE("effective");

    private final String rate;

    Rate(String r) {
      this.rate = r;
    }

    @Override
    public String toString() {
      return this.rate;
    }
  }

  public enum Currency {
    USD,
    AUD,
    CHF,
    CKK,
    EUR,
    GBP,
    HKD,
    JPY,
    NOK,
    NZD,
    SEK,
    ZAR
  }

  public enum Period {
    @SerializedName("h")
    HOURLY("h"),

    @SerializedName("d")
    DAILY("d"),

    @SerializedName("w")
    WEEKLY("w"),

    @SerializedName("m")
    MONTHLY("m"),

    @SerializedName("y")
    YEARLY("y");
    private final String period;

    Period(String p) {
      this.period = p;
    }

    @Override
    public String toString() {
      return this.period;
    }
  }
}
