package co.cloudcraft.model;

import lombok.*;

/**
 * Data object representing parameters required for registering a new IAM Role in AWS for use with
 * Cloudcraft, customized to user.
 */
@RequiredArgsConstructor
@Getter
@EqualsAndHashCode(callSuper = false)
@ToString
public class IAMParameters extends CloudcraftObject {
  /** The AWS Account ID */
  private final String accountId;

  /** External Id for the account */
  private final String externalId;

  /** AWS console URL pointing to the role. */
  private final String awsConsoleUrl;
}
