package co.cloudcraft.model;

import com.google.gson.annotations.SerializedName;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@EqualsAndHashCode(callSuper = true)
@ToString
public class SnapshotAccountQueryParams extends ExportBlueprintQueryParams {
  /**
   * Render a subset of the AWS account. Accepts a filter expression as used on the Live tab in the
   * web application. Terms of the filter expression must be separated by spaces. The terms are
   * substrings to be matched, key-value pairs, logical operators or parentheses. Example: `env=dev
   * OR env=test`
   */
  private final String filter;
  /**
   * Exclude AWS services by name. Example: "ec2,sg" to exclude both EC2s and Security Groups. The
   * service value is specified by the "type" field of Blueprint components.
   */
  private final String exclude;
  /** Automatically label all components. If not provided, will default to <code>true</code> */
  private final Boolean label;

  /** Automatically connect all components. If not provided, will default to <code>true</code> */
  private final Boolean autoconnect;

  /** The visual style of the diagram. */
  private final Projection projection;

  /** The color theme of the diagram. */
  private final Theme theme;

  @Builder(builderMethodName = "snapShotParamsBuilder")
  private SnapshotAccountQueryParams(
      Float scale,
      Integer width,
      Integer height,
      Boolean grid,
      Boolean transparent,
      Boolean landscape,
      PaperSize paperSize,
      String filter,
      String exclude,
      Boolean label,
      Boolean autoconnect,
      Projection projection,
      Theme theme) {
    super(scale, width, height, grid, transparent, landscape, paperSize);
    this.filter = filter;
    this.exclude = exclude;
    this.label = label;
    this.autoconnect = autoconnect;
    this.projection = projection;
    this.theme = theme;
  }

  public enum Projection {
    ISOMETRIC("isometric"),
    @SerializedName("2d")
    TWO_DIMENSIONAL("2d");

    private final String projection;

    Projection(String p) {
      this.projection = p;
    }

    @Override
    public String toString() {
      return this.projection;
    }
  }

  public enum Theme {
    LIGHT("light"),
    DARK("dark");
    private final String theme;

    Theme(String t) {
      this.theme = t;
    }

    @Override
    public String toString() {
      return this.theme;
    }
  }
}
