package co.cloudcraft.model;

import lombok.*;

/** Represents User in Cloudcraft. */
@RequiredArgsConstructor
@Getter
@EqualsAndHashCode(callSuper = false)
@ToString
public class User extends CloudcraftObject {
  /** Cloudcraft issued unique identifier. */
  private final String id;

  /** Name of the user. */
  private final String name;

  /** Email of the user. */
  private final String email;

  /** User settings configured in Cloudcraft. Settings will be in JSON tree. */
  private final Object settings;

  @Getter(AccessLevel.NONE)
  private final String createdAt;

  @Getter(AccessLevel.NONE)
  private final String updatedAt;

  @Getter(AccessLevel.NONE)
  private final String accessedAt;

  /**
   * Returns when the user was registered with Cloudcraft.
   *
   * @return creation time in milliseconds since epoch.
   */
  public Long getCreatedTime() {
    return convertDateStringToInstant(this.createdAt);
  }

  /**
   * Returns when the user account was last updated.
   *
   * @return updated time in milliseconds since epoch.
   */
  public Long getUpdatedTime() {
    return convertDateStringToInstant(this.updatedAt);
  }

  /**
   * Returns when the user last access Cloudcraft.
   *
   * @return last accessed time in milliseconds since epoch.
   */
  public Long getLastAccessedTime() {
    return convertDateStringToInstant(this.accessedAt);
  }
}
