/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft;

public class ClientConfig {
    private static final long serialVersionUID = 2L;
    public static final String DEFAULT_PROTOCOL = "https";
    public static final String DEFAULT_HOST = "api.cloudcraft.co";
    public static final String DEFAULT_BASE_PATH = "";
    public static final int DEFAULT_PORT = 443;
    public static final int DEFAULT_TIMEOUT_MS = 80000;
    public static final int DEFAULT_MAX_NETWORK_RETRIES = 10;
    private String protocol;
    private String host;
    private Integer port;
    private Integer readTimeout;
    private Integer maxRetries;

    ClientConfig(String protocol, String host, Integer port, Integer readTimeout, Integer maxRetries) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.readTimeout = readTimeout;
        this.maxRetries = maxRetries;
    }

    public static ClientConfigBuilder builder() {
        return new ClientConfigBuilder();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfig)) {
            return false;
        }
        ClientConfig other = (ClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$readTimeout = this.getReadTimeout();
        Integer other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Integer this$maxRetries = this.getMaxRetries();
        Integer other$maxRetries = other.getMaxRetries();
        if (this$maxRetries == null ? other$maxRetries != null : !((Object)this$maxRetries).equals(other$maxRetries)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Integer $maxRetries = this.getMaxRetries();
        result = result * 59 + ($maxRetries == null ? 43 : ((Object)$maxRetries).hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "ClientConfig(protocol=" + this.getProtocol() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", readTimeout=" + this.getReadTimeout() + ", maxRetries=" + this.getMaxRetries() + ")";
    }

    public static class ClientConfigBuilder {
        private String protocol;
        private String host;
        private Integer port;
        private Integer readTimeout;
        private Integer maxRetries;

        ClientConfigBuilder() {
        }

        public ClientConfigBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public ClientConfigBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ClientConfigBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public ClientConfigBuilder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ClientConfigBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ClientConfig build() {
            return new ClientConfig(this.protocol, this.host, this.port, this.readTimeout, this.maxRetries);
        }

        public String toString() {
            return "ClientConfig.ClientConfigBuilder(protocol=" + this.protocol + ", host=" + this.host + ", port=" + this.port + ", readTimeout=" + this.readTimeout + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

