/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft;

import co.cloudcraft.ClientConfig;
import co.cloudcraft.RestClient;
import co.cloudcraft.api.AwsAccountApi;
import co.cloudcraft.api.BlueprintApi;
import co.cloudcraft.api.BudgetApi;
import co.cloudcraft.api.UserApi;
import co.cloudcraft.exception.CloudcraftException;

public class Cloudcraft {
    private static final String CLOUDCRAFT_PROTOCOL = "CLOUDCRAFT_PROTOCOL";
    private static final String CLOUDCRAFT_HOST = "CLOUDCRAFT_HOST";
    private static final String CLOUDCRAFT_PORT = "CLOUDCRAFT_PORT";
    private static final String CLOUDCRAFT_API_KEY = "CLOUDCRAFT_API_KEY";
    private static final String CLOUDCRAFT_TIMEOUT = "CLOUDCRAFT_TIMEOUT";
    private static final String CLOUDCRAFT_MAX_NETWORK_RETRIES = "CLOUDCRAFT_MAX_NETWORK_RETRIES";
    private ClientConfig clientConfig;
    private final String apiKey;
    private final RestClient restClient;
    private final UserApi userApi;
    private final AwsAccountApi awsAccountApi;
    private final BlueprintApi blueprintApi;
    private final BudgetApi budgetApi;

    public Cloudcraft() throws CloudcraftException {
        this(null, null);
    }

    public Cloudcraft(String apiKey) throws CloudcraftException {
        this(apiKey, null);
    }

    public Cloudcraft(String apiKey, ClientConfig clientConfigOverrides) throws CloudcraftException {
        String string = this.apiKey = apiKey != null ? apiKey : System.getenv(CLOUDCRAFT_API_KEY);
        if (this.apiKey == null) {
            throw new CloudcraftException("No API key specified", "400");
        }
        this.initializeClientConfig(clientConfigOverrides);
        this.restClient = new RestClient(this.apiKey, this.clientConfig);
        this.userApi = new UserApi(this.restClient);
        this.awsAccountApi = new AwsAccountApi(this.restClient);
        this.blueprintApi = new BlueprintApi(this.restClient);
        this.budgetApi = new BudgetApi(this.restClient);
    }

    private void initializeClientConfig(ClientConfig clientConfigOverrides) {
        String host;
        String protocol;
        String string = clientConfigOverrides != null && clientConfigOverrides.getProtocol() != null ? clientConfigOverrides.getProtocol() : (protocol = System.getenv(CLOUDCRAFT_PROTOCOL) != null ? System.getenv(CLOUDCRAFT_PROTOCOL) : "https");
        String string2 = clientConfigOverrides != null && clientConfigOverrides.getHost() != null ? clientConfigOverrides.getHost() : (host = System.getenv(CLOUDCRAFT_HOST) != null ? System.getenv(CLOUDCRAFT_HOST) : "api.cloudcraft.co");
        Integer port = clientConfigOverrides != null && clientConfigOverrides.getPort() != null ? clientConfigOverrides.getPort() : (System.getenv(CLOUDCRAFT_PORT) != null ? Integer.parseInt(System.getenv(CLOUDCRAFT_PORT)) : 443);
        Integer maxRetries = clientConfigOverrides != null && clientConfigOverrides.getMaxRetries() != null ? clientConfigOverrides.getMaxRetries() : (System.getenv(CLOUDCRAFT_MAX_NETWORK_RETRIES) != null ? Integer.parseInt(System.getenv(CLOUDCRAFT_MAX_NETWORK_RETRIES)) : 10);
        Integer readTimeout = clientConfigOverrides != null && clientConfigOverrides.getReadTimeout() != null ? clientConfigOverrides.getReadTimeout() : (System.getenv(CLOUDCRAFT_TIMEOUT) != null ? Integer.parseInt(System.getenv(CLOUDCRAFT_TIMEOUT)) : 80000);
        this.clientConfig = new ClientConfig(protocol, host, port, readTimeout, maxRetries);
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public UserApi getUserApi() {
        return this.userApi;
    }

    public AwsAccountApi getAwsAccountApi() {
        return this.awsAccountApi;
    }

    public BlueprintApi getBlueprintApi() {
        return this.blueprintApi;
    }

    public BudgetApi getBudgetApi() {
        return this.budgetApi;
    }
}

