/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft;

import co.cloudcraft.ClientConfig;
import co.cloudcraft.exception.AuthenticationException;
import co.cloudcraft.exception.CloudcraftException;
import co.cloudcraft.exception.ErrorResponse;
import co.cloudcraft.exception.InvalidRequestException;
import co.cloudcraft.exception.NotFoundException;
import co.cloudcraft.exception.PermissionException;
import co.cloudcraft.exception.RateLimitException;
import co.cloudcraft.exception.ResourceOutofDateException;
import co.cloudcraft.model.CloudcraftObject;
import co.cloudcraft.model.CloudcraftResponse;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EmptyInputStream;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.util.Timeout;

public class RestClient {
    private final String apiKey;
    private final String baseUrl;
    CloseableHttpClient httpClient;

    public RestClient(String apiKey, ClientConfig config) {
        this.apiKey = apiKey;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        requestConfigBuilder.setConnectTimeout(Timeout.of((long)config.getReadTimeout().intValue(), (TimeUnit)TimeUnit.MILLISECONDS));
        requestConfigBuilder.setConnectionRequestTimeout(Timeout.of((long)config.getReadTimeout().intValue(), (TimeUnit)TimeUnit.MILLISECONDS));
        RequestConfig httpConfig = requestConfigBuilder.build();
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(httpConfig);
        this.httpClient = builder.build();
        String apiBasePath = System.getenv("CLOUDCRAFT_BASE_PATH") != null ? System.getenv("CLOUDCRAFT_BASE_PATH") : "";
        this.baseUrl = String.format("%s://%s:%d%s", config.getProtocol(), config.getHost(), config.getPort(), apiBasePath);
    }

    public CloudcraftResponse execute(Method method, String path) throws CloudcraftException {
        return this.execute(method, path, null, null, null);
    }

    public CloudcraftResponse execute(Method method, String path, Map<String, String> params) throws CloudcraftException {
        return this.execute(method, path, null, null, params);
    }

    public CloudcraftResponse execute(Method method, String path, Map<String, String> headers, String requestBodyJson) throws CloudcraftException {
        return this.execute(method, path, headers, requestBodyJson, null);
    }

    CloudcraftResponse execute(Method method, String path, Map<String, String> headers, String requestBodyJson, Map<String, String> params) throws CloudcraftException {
        try {
            ClassicRequestBuilder reqBuilder = ClassicRequestBuilder.create((String)method.toString()).setUri(this.constructFullPath(path));
            this.addHeaders(reqBuilder, headers);
            this.addParameters(reqBuilder, params);
            if (requestBodyJson != null) {
                reqBuilder.setEntity(requestBodyJson, ContentType.APPLICATION_JSON);
            }
            CloseableHttpResponse httpResponse = this.httpClient.execute(reqBuilder.build());
            HttpEntity httpEntity = httpResponse.getEntity();
            int responseCode = httpResponse.getCode();
            String responseContentType = this.getHeader(httpResponse.getHeaders(), "Content-Type");
            if (responseCode < 200 || responseCode >= 300) {
                try {
                    String responseBodyAsString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                    this.handleErrorResponse(responseCode, responseBodyAsString, responseContentType);
                }
                catch (ParseException pe) {
                    this.handleParseException(responseCode, "Unable to parse response", pe);
                }
            }
            return new CloudcraftResponse(httpResponse.getCode(), httpEntity != null ? httpEntity.getContent() : EmptyInputStream.INSTANCE, responseContentType, this.getHeader(httpResponse.getHeaders(), "ETag"));
        }
        catch (IOException ioe) {
            throw new CloudcraftException(ioe.getMessage(), "500", 500, ioe);
        }
    }

    void handleErrorResponse(int responseCode, String responseBody, String contentType) throws CloudcraftException {
        try {
            CloudcraftException exception;
            ErrorResponse error = contentType.startsWith("application/json") ? (responseBody != null ? (ErrorResponse)CloudcraftObject.GSON.fromJson(responseBody, ErrorResponse.class) : new ErrorResponse("No additional information", responseCode)) : new ErrorResponse(responseBody, responseCode);
            switch (responseCode) {
                case 400: {
                    exception = new InvalidRequestException(error);
                    break;
                }
                case 404: {
                    exception = new NotFoundException(error);
                    break;
                }
                case 403: {
                    exception = new PermissionException(error);
                    break;
                }
                case 401: {
                    exception = new AuthenticationException(error);
                    break;
                }
                case 429: {
                    exception = new RateLimitException(error);
                    break;
                }
                case 412: {
                    exception = new ResourceOutofDateException(error);
                    break;
                }
                default: {
                    exception = new CloudcraftException(error, responseCode);
                }
            }
            throw exception;
        }
        catch (JsonSyntaxException e) {
            this.handleParseException(responseCode, responseBody, e);
            return;
        }
    }

    void handleParseException(int responseCode, String responseBody, Throwable e) throws CloudcraftException {
        String details = e == null ? "none" : e.getMessage();
        String apiResponseBody = responseBody == null ? "unparsable" : responseBody;
        throw new CloudcraftException(String.format("Invalid response object from API: %s. (HTTP response code was %d). Additional details: %s.", apiResponseBody, responseCode, details), Integer.toString(responseCode), responseCode, e);
    }

    void addHeaders(ClassicRequestBuilder reqBuilder, Map<String, String> headers) {
        reqBuilder.addHeader("Authorization", "Bearer " + this.apiKey);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                reqBuilder.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    void addParameters(ClassicRequestBuilder reqBuilder, Map<String, String> params) {
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                reqBuilder.addParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    String constructFullPath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.baseUrl + path;
    }

    public String getHeader(@NonNull Header[] headers, @NonNull String headerName) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (headerName == null) {
            throw new NullPointerException("headerName is marked non-null but is null");
        }
        if (headers == null) {
            return null;
        }
        Optional<Header> header = Arrays.stream(headers).filter(h -> h.getName().equalsIgnoreCase(headerName)).findFirst();
        return header.map(NameValuePair::getValue).orElse(null);
    }
}

