/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft.api;

import co.cloudcraft.RestClient;
import co.cloudcraft.exception.CloudcraftException;
import co.cloudcraft.model.CloudcraftObject;
import co.cloudcraft.model.CloudcraftResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.core5.http.ContentType;

public abstract class ApiBase {
    protected final RestClient restClient;
    protected static final Map<String, String> CONTENT_TYPE_HEADER_MAP = new HashMap<String, String>();

    public ApiBase(RestClient restClient) {
        this.restClient = restClient;
    }

    <T> T parseCloudcraftResponse(CloudcraftResponse response, Class<T> clazz) throws CloudcraftException {
        int statusCode = response.getStatusCode();
        if (statusCode == 204 && clazz.equals(Void.class)) {
            return null;
        }
        Object ccResponse = CloudcraftObject.GSON.fromJson(response.getResponseAsString(), clazz);
        if (ccResponse instanceof CloudcraftObject) {
            ((CloudcraftObject)ccResponse).setETag(response.getETag());
        }
        return (T)ccResponse;
    }

    static {
        CONTENT_TYPE_HEADER_MAP.put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
    }

    public static enum BlueprintExportFormat {
        SVG("svg"),
        PDF("pdf"),
        PNG("png"),
        MX_GRAPH("mxGraph"),
        JSON("json");

        private final String format;

        private BlueprintExportFormat(String f) {
            this.format = f;
        }

        public String toString() {
            return this.format;
        }
    }

    public static enum BudgetExportFormat {
        CSV("csv"),
        XLSX("xlsx");

        private final String format;

        private BudgetExportFormat(String f) {
            this.format = f;
        }

        public String toString() {
            return this.format;
        }
    }
}

