/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft.api;

import co.cloudcraft.RestClient;
import co.cloudcraft.api.ApiBase;
import co.cloudcraft.exception.CloudcraftException;
import co.cloudcraft.model.AwsAccount;
import co.cloudcraft.model.AwsAccountCollection;
import co.cloudcraft.model.AwsAccountRequest;
import co.cloudcraft.model.CloudcraftResponse;
import co.cloudcraft.model.IAMParameters;
import co.cloudcraft.model.SnapshotAccountQueryParams;
import java.util.Map;
import lombok.NonNull;
import org.apache.hc.core5.http.Method;

public class AwsAccountApi
extends ApiBase {
    public AwsAccountApi(RestClient restClient) {
        super(restClient);
    }

    public IAMParameters getCloudcraftIAMRoleConfig() throws CloudcraftException {
        CloudcraftResponse response = this.restClient.execute(Method.GET, "/aws/account/iamParameters");
        return this.parseCloudcraftResponse(response, IAMParameters.class);
    }

    public AwsAccount add(@NonNull AwsAccountRequest accountRequest) throws CloudcraftException {
        if (accountRequest == null) {
            throw new NullPointerException("accountRequest is marked non-null but is null");
        }
        accountRequest.validate();
        CloudcraftResponse response = this.restClient.execute(Method.POST, "/aws/account", CONTENT_TYPE_HEADER_MAP, accountRequest.toJson());
        return this.parseCloudcraftResponse(response, AwsAccount.class);
    }

    public AwsAccount update(@NonNull String accountId, @NonNull AwsAccountRequest accountRequest) throws CloudcraftException {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (accountRequest == null) {
            throw new NullPointerException("accountRequest is marked non-null but is null");
        }
        accountRequest.validate();
        CloudcraftResponse response = this.restClient.execute(Method.PUT, String.format("/aws/account/%s", accountId), CONTENT_TYPE_HEADER_MAP, accountRequest.toJson());
        return this.parseCloudcraftResponse(response, AwsAccount.class);
    }

    public void delete(@NonNull String accountId) throws CloudcraftException {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        this.restClient.execute(Method.DELETE, String.format("/aws/account/%s", accountId));
    }

    public AwsAccountCollection list() throws CloudcraftException {
        CloudcraftResponse response = this.restClient.execute(Method.GET, "/aws/account");
        return this.parseCloudcraftResponse(response, AwsAccountCollection.class);
    }

    public CloudcraftResponse snapshot(@NonNull String accountId, @NonNull String region, @NonNull ApiBase.BlueprintExportFormat format, SnapshotAccountQueryParams requestParams) throws CloudcraftException {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        Map<String, String> paramsMap = requestParams != null ? requestParams.toMap() : null;
        return this.restClient.execute(Method.GET, String.format("/aws/account/%s/%s/%s", new Object[]{accountId, region, format}), paramsMap);
    }
}

