/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft.api;

import co.cloudcraft.RestClient;
import co.cloudcraft.api.ApiBase;
import co.cloudcraft.exception.CloudcraftException;
import co.cloudcraft.model.Blueprint;
import co.cloudcraft.model.BlueprintCollection;
import co.cloudcraft.model.BlueprintRequest;
import co.cloudcraft.model.CloudcraftResponse;
import co.cloudcraft.model.ExportBlueprintQueryParams;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.hc.core5.http.Method;

public class BlueprintApi
extends ApiBase {
    public BlueprintApi(RestClient restClient) {
        super(restClient);
    }

    public BlueprintCollection list() throws CloudcraftException {
        CloudcraftResponse response = this.restClient.execute(Method.GET, "/blueprint");
        return this.parseCloudcraftResponse(response, BlueprintCollection.class);
    }

    public Blueprint create(@NonNull BlueprintRequest blueprintRequest) throws CloudcraftException {
        if (blueprintRequest == null) {
            throw new NullPointerException("blueprintRequest is marked non-null but is null");
        }
        CloudcraftResponse response = this.restClient.execute(Method.POST, "/blueprint", CONTENT_TYPE_HEADER_MAP, blueprintRequest.toJson());
        return this.parseCloudcraftResponse(response, Blueprint.class);
    }

    public Blueprint get(@NonNull String blueprintId) throws CloudcraftException {
        if (blueprintId == null) {
            throw new NullPointerException("blueprintId is marked non-null but is null");
        }
        CloudcraftResponse response = this.restClient.execute(Method.GET, String.format("/blueprint/%s", blueprintId));
        return this.parseCloudcraftResponse(response, Blueprint.class);
    }

    public void update(@NonNull String blueprintId, @NonNull BlueprintRequest blueprintRequest) throws CloudcraftException {
        if (blueprintId == null) {
            throw new NullPointerException("blueprintId is marked non-null but is null");
        }
        if (blueprintRequest == null) {
            throw new NullPointerException("blueprintRequest is marked non-null but is null");
        }
        this.updateWithEtag(blueprintId, blueprintRequest, null);
    }

    public void updateWithEtag(@NonNull String blueprintId, @NonNull BlueprintRequest blueprintRequest, String eTag) throws CloudcraftException {
        if (blueprintId == null) {
            throw new NullPointerException("blueprintId is marked non-null but is null");
        }
        if (blueprintRequest == null) {
            throw new NullPointerException("blueprintRequest is marked non-null but is null");
        }
        HashMap<String, String> headers = new HashMap<String, String>(CONTENT_TYPE_HEADER_MAP);
        if (eTag != null) {
            headers.put("If-Match", eTag);
        }
        this.restClient.execute(Method.PUT, String.format("/blueprint/%s", blueprintId), headers, blueprintRequest.toJson());
    }

    public void delete(@NonNull String blueprintId) throws CloudcraftException {
        if (blueprintId == null) {
            throw new NullPointerException("blueprintId is marked non-null but is null");
        }
        this.restClient.execute(Method.DELETE, String.format("/blueprint/%s", blueprintId));
    }

    public CloudcraftResponse exportBlueprint(@NonNull String blueprintId, @NonNull ApiBase.BlueprintExportFormat format, ExportBlueprintQueryParams requestParams) throws CloudcraftException {
        if (blueprintId == null) {
            throw new NullPointerException("blueprintId is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        Map<String, String> paramsMap = requestParams != null ? requestParams.toMap() : null;
        return this.restClient.execute(Method.GET, String.format("/blueprint/%s/%s", new Object[]{blueprintId, format}), paramsMap);
    }
}

