/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft.model;

import co.cloudcraft.exception.ErrorResponse;
import co.cloudcraft.exception.InvalidRequestException;
import co.cloudcraft.model.AwsAccount;
import co.cloudcraft.model.CloudcraftObject;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import lombok.NonNull;

public class AwsAccountRequest
extends CloudcraftObject {
    @NonNull
    private String name;
    @NonNull
    private String roleArn;
    @SerializedName(value="region")
    private String accountValidationRegion;
    private String[] readAccess;
    private String[] writeAccess;

    public AwsAccountRequest(AwsAccount account) {
        this.name = account.getName();
        this.roleArn = account.getRoleArn();
        this.readAccess = account.getReadAccess();
        this.writeAccess = account.getWriteAccess();
    }

    public void validate() throws InvalidRequestException {
        if (this.name.trim().isEmpty()) {
            throw new InvalidRequestException(new ErrorResponse("Missing required parameter: name", 400));
        }
        if (this.roleArn.trim().isEmpty()) {
            throw new InvalidRequestException(new ErrorResponse("Missing required parameter: roleArn", 400));
        }
        String[] segments = this.roleArn.trim().split(":");
        if (segments.length < 6 || !this.roleArn.startsWith("arn")) {
            throw new InvalidRequestException(new ErrorResponse(String.format("Invalid roleArn specified: %s", this.roleArn), 400));
        }
    }

    public AwsAccountRequest(@NonNull String name, @NonNull String roleArn, String accountValidationRegion, String[] readAccess, String[] writeAccess) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (roleArn == null) {
            throw new NullPointerException("roleArn is marked non-null but is null");
        }
        this.name = name;
        this.roleArn = roleArn;
        this.accountValidationRegion = accountValidationRegion;
        this.readAccess = readAccess;
        this.writeAccess = writeAccess;
    }

    public AwsAccountRequest(@NonNull String name, @NonNull String roleArn) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (roleArn == null) {
            throw new NullPointerException("roleArn is marked non-null but is null");
        }
        this.name = name;
        this.roleArn = roleArn;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getRoleArn() {
        return this.roleArn;
    }

    public String getAccountValidationRegion() {
        return this.accountValidationRegion;
    }

    public String[] getReadAccess() {
        return this.readAccess;
    }

    public String[] getWriteAccess() {
        return this.writeAccess;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setRoleArn(@NonNull String roleArn) {
        if (roleArn == null) {
            throw new NullPointerException("roleArn is marked non-null but is null");
        }
        this.roleArn = roleArn;
    }

    public void setAccountValidationRegion(String accountValidationRegion) {
        this.accountValidationRegion = accountValidationRegion;
    }

    public void setReadAccess(String[] readAccess) {
        this.readAccess = readAccess;
    }

    public void setWriteAccess(String[] writeAccess) {
        this.writeAccess = writeAccess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsAccountRequest)) {
            return false;
        }
        AwsAccountRequest other = (AwsAccountRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$roleArn = this.getRoleArn();
        String other$roleArn = other.getRoleArn();
        if (this$roleArn == null ? other$roleArn != null : !this$roleArn.equals(other$roleArn)) {
            return false;
        }
        String this$accountValidationRegion = this.getAccountValidationRegion();
        String other$accountValidationRegion = other.getAccountValidationRegion();
        if (this$accountValidationRegion == null ? other$accountValidationRegion != null : !this$accountValidationRegion.equals(other$accountValidationRegion)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getReadAccess(), other.getReadAccess())) {
            return false;
        }
        return Arrays.deepEquals(this.getWriteAccess(), other.getWriteAccess());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AwsAccountRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $roleArn = this.getRoleArn();
        result = result * 59 + ($roleArn == null ? 43 : $roleArn.hashCode());
        String $accountValidationRegion = this.getAccountValidationRegion();
        result = result * 59 + ($accountValidationRegion == null ? 43 : $accountValidationRegion.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReadAccess());
        result = result * 59 + Arrays.deepHashCode(this.getWriteAccess());
        return result;
    }

    public String toString() {
        return "AwsAccountRequest(name=" + this.getName() + ", roleArn=" + this.getRoleArn() + ", accountValidationRegion=" + this.getAccountValidationRegion() + ", readAccess=" + Arrays.deepToString(this.getReadAccess()) + ", writeAccess=" + Arrays.deepToString(this.getWriteAccess()) + ")";
    }
}

