/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft.model;

import co.cloudcraft.model.BlueprintData;
import co.cloudcraft.model.CloudcraftObject;
import java.util.Arrays;
import lombok.NonNull;

public class BlueprintRequest
extends CloudcraftObject {
    @NonNull
    private BlueprintData data;
    private String[] readAccess;
    private String[] writeAccess;

    public BlueprintRequest() {
    }

    public BlueprintRequest(@NonNull BlueprintData data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
    }

    public BlueprintRequest(@NonNull BlueprintData data, String[] readAccess, String[] writeAccess) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
        this.readAccess = readAccess;
        this.writeAccess = writeAccess;
    }

    @NonNull
    public BlueprintData getData() {
        return this.data;
    }

    public String[] getReadAccess() {
        return this.readAccess;
    }

    public String[] getWriteAccess() {
        return this.writeAccess;
    }

    public void setData(@NonNull BlueprintData data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
    }

    public void setReadAccess(String[] readAccess) {
        this.readAccess = readAccess;
    }

    public void setWriteAccess(String[] writeAccess) {
        this.writeAccess = writeAccess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlueprintRequest)) {
            return false;
        }
        BlueprintRequest other = (BlueprintRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlueprintData this$data = this.getData();
        BlueprintData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getReadAccess(), other.getReadAccess())) {
            return false;
        }
        return Arrays.deepEquals(this.getWriteAccess(), other.getWriteAccess());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlueprintRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlueprintData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReadAccess());
        result = result * 59 + Arrays.deepHashCode(this.getWriteAccess());
        return result;
    }

    public String toString() {
        return "BlueprintRequest(data=" + this.getData() + ", readAccess=" + Arrays.deepToString(this.getReadAccess()) + ", writeAccess=" + Arrays.deepToString(this.getWriteAccess()) + ")";
    }
}

