/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public abstract class CloudcraftObject {
    protected static final long serialVersionUID = 2L;
    protected String eTag;
    public static final Gson PRETTY_PRINT_GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    public static final Gson GSON = new GsonBuilder().create();

    public String prettyPrint() {
        return String.format("%s", PRETTY_PRINT_GSON.toJson((Object)this));
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    protected Long convertDateStringToInstant(String dateAsString) {
        if (dateAsString == null) {
            return null;
        }
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(dateAsString)).toEpochMilli();
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getETag() {
        return this.eTag;
    }
}

