/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft.model;

import co.cloudcraft.exception.CloudcraftException;
import co.cloudcraft.model.CloudcraftObject;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public class CloudcraftResponse {
    Integer statusCode;
    InputStream responseBody;
    String contentType;
    String eTag;

    public String getResponseAsString() throws CloudcraftException {
        if (this.canConvertToString()) {
            return new BufferedReader(new InputStreamReader(this.responseBody, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        }
        throw new CloudcraftException(String.format("Response cannot be converted to String: content-type:%s", this.contentType), "400");
    }

    public JsonObject getResponseAsJson() throws CloudcraftException {
        if (!this.contentType.startsWith("application/json")) {
            throw new CloudcraftException(String.format("Response cannot be converted to JSON Object: content-type:%s", this.contentType), "400");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.responseBody, StandardCharsets.UTF_8));
        return (JsonObject)CloudcraftObject.GSON.fromJson((Reader)reader, JsonObject.class);
    }

    public byte[] getResponseAsBytes() throws IOException {
        int nRead;
        if (this.responseBody == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = this.responseBody.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private boolean canConvertToString() {
        return this.contentType.startsWith("application/json") || this.contentType.startsWith("application/xml") || this.contentType.startsWith("image/svg+xml") || this.contentType.startsWith("text/csv");
    }

    public CloudcraftResponse(Integer statusCode, InputStream responseBody, String contentType, String eTag) {
        this.statusCode = statusCode;
        this.responseBody = responseBody;
        this.contentType = contentType;
        this.eTag = eTag;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public InputStream getResponseBody() {
        return this.responseBody;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getETag() {
        return this.eTag;
    }

    public String toString() {
        return "CloudcraftResponse(statusCode=" + this.getStatusCode() + ", responseBody=" + this.getResponseBody() + ", contentType=" + this.getContentType() + ", eTag=" + this.getETag() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudcraftResponse)) {
            return false;
        }
        CloudcraftResponse other = (CloudcraftResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$statusCode = this.getStatusCode();
        Integer other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        InputStream this$responseBody = this.getResponseBody();
        InputStream other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$eTag = this.getETag();
        String other$eTag = other.getETag();
        return !(this$eTag == null ? other$eTag != null : !this$eTag.equals(other$eTag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CloudcraftResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        InputStream $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $eTag = this.getETag();
        result = result * 59 + ($eTag == null ? 43 : $eTag.hashCode());
        return result;
    }
}

