/*
 * Decompiled with CFR 0.152.
 */
package co.cloudcraft.model;

import co.cloudcraft.model.CloudcraftObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class ExportBudgetQueryParams {
    private final Currency currency;
    private final Period period;
    private final Rate rate;

    public Map<String, String> toMap() {
        String js = CloudcraftObject.GSON.toJson((Object)this);
        Type exportBlueprintRequestType = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)CloudcraftObject.GSON.fromJson(js, exportBlueprintRequestType);
    }

    ExportBudgetQueryParams(Currency currency, Period period, Rate rate) {
        this.currency = currency;
        this.period = period;
        this.rate = rate;
    }

    public static ExportBudgetQueryParamsBuilder builder() {
        return new ExportBudgetQueryParamsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportBudgetQueryParams)) {
            return false;
        }
        ExportBudgetQueryParams other = (ExportBudgetQueryParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Currency this$currency = this.currency;
        Currency other$currency = other.currency;
        if (this$currency == null ? other$currency != null : !((Object)((Object)this$currency)).equals((Object)other$currency)) {
            return false;
        }
        Period this$period = this.period;
        Period other$period = other.period;
        if (this$period == null ? other$period != null : !((Object)((Object)this$period)).equals((Object)other$period)) {
            return false;
        }
        Rate this$rate = this.rate;
        Rate other$rate = other.rate;
        return !(this$rate == null ? other$rate != null : !((Object)((Object)this$rate)).equals((Object)other$rate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExportBudgetQueryParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Currency $currency = this.currency;
        result = result * 59 + ($currency == null ? 43 : ((Object)((Object)$currency)).hashCode());
        Period $period = this.period;
        result = result * 59 + ($period == null ? 43 : ((Object)((Object)$period)).hashCode());
        Rate $rate = this.rate;
        result = result * 59 + ($rate == null ? 43 : ((Object)((Object)$rate)).hashCode());
        return result;
    }

    public String toString() {
        return "ExportBudgetQueryParams(currency=" + (Object)((Object)this.currency) + ", period=" + (Object)((Object)this.period) + ", rate=" + (Object)((Object)this.rate) + ")";
    }

    public static enum Currency {
        USD,
        AUD,
        CHF,
        CKK,
        EUR,
        GBP,
        HKD,
        JPY,
        NOK,
        NZD,
        SEK,
        ZAR;

    }

    public static enum Period {
        HOURLY("h"),
        DAILY("d"),
        WEEKLY("w"),
        MONTHLY("m"),
        YEARLY("y");

        private final String period;

        private Period(String p) {
            this.period = p;
        }

        public String toString() {
            return this.period;
        }
    }

    public static enum Rate {
        STATED("stated"),
        EFFECTIVE("effective");

        private final String rate;

        private Rate(String r) {
            this.rate = r;
        }

        public String toString() {
            return this.rate;
        }
    }

    public static class ExportBudgetQueryParamsBuilder {
        private Currency currency;
        private Period period;
        private Rate rate;

        ExportBudgetQueryParamsBuilder() {
        }

        public ExportBudgetQueryParamsBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public ExportBudgetQueryParamsBuilder period(Period period) {
            this.period = period;
            return this;
        }

        public ExportBudgetQueryParamsBuilder rate(Rate rate) {
            this.rate = rate;
            return this;
        }

        public ExportBudgetQueryParams build() {
            return new ExportBudgetQueryParams(this.currency, this.period, this.rate);
        }

        public String toString() {
            return "ExportBudgetQueryParams.ExportBudgetQueryParamsBuilder(currency=" + (Object)((Object)this.currency) + ", period=" + (Object)((Object)this.period) + ", rate=" + (Object)((Object)this.rate) + ")";
        }
    }
}

