/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.0.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Attribute;
import co.permify.sdk.model.DataChangeOperation;
import co.permify.sdk.model.Tuple;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import co.permify.sdk.client.ApiClient;
/**
 * DataChange represents a single change in data, with an operation type and the actual change which could be a tuple or an attribute.
 */
@JsonPropertyOrder({
  DataChange.JSON_PROPERTY_OPERATION,
  DataChange.JSON_PROPERTY_TUPLE,
  DataChange.JSON_PROPERTY_ATTRIBUTE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.14.0")
public class DataChange {
  public static final String JSON_PROPERTY_OPERATION = "operation";
  @jakarta.annotation.Nullable
  private DataChangeOperation operation = DataChangeOperation.OPERATION_UNSPECIFIED;

  public static final String JSON_PROPERTY_TUPLE = "tuple";
  @jakarta.annotation.Nullable
  private Tuple tuple;

  public static final String JSON_PROPERTY_ATTRIBUTE = "attribute";
  @jakarta.annotation.Nullable
  private Attribute attribute;

  public DataChange() { 
  }

  public DataChange operation(@jakarta.annotation.Nullable DataChangeOperation operation) {
    this.operation = operation;
    return this;
  }

  /**
   * Get operation
   * @return operation
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DataChangeOperation getOperation() {
    return operation;
  }


  @JsonProperty(JSON_PROPERTY_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperation(@jakarta.annotation.Nullable DataChangeOperation operation) {
    this.operation = operation;
  }


  public DataChange tuple(@jakarta.annotation.Nullable Tuple tuple) {
    this.tuple = tuple;
    return this;
  }

  /**
   * Get tuple
   * @return tuple
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TUPLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Tuple getTuple() {
    return tuple;
  }


  @JsonProperty(JSON_PROPERTY_TUPLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTuple(@jakarta.annotation.Nullable Tuple tuple) {
    this.tuple = tuple;
  }


  public DataChange attribute(@jakarta.annotation.Nullable Attribute attribute) {
    this.attribute = attribute;
    return this;
  }

  /**
   * Get attribute
   * @return attribute
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Attribute getAttribute() {
    return attribute;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttribute(@jakarta.annotation.Nullable Attribute attribute) {
    this.attribute = attribute;
  }


  /**
   * Return true if this DataChange object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataChange dataChange = (DataChange) o;
    return Objects.equals(this.operation, dataChange.operation) &&
        Objects.equals(this.tuple, dataChange.tuple) &&
        Objects.equals(this.attribute, dataChange.attribute);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operation, tuple, attribute);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataChange {\n");
    sb.append("    operation: ").append(toIndentedString(operation)).append("\n");
    sb.append("    tuple: ").append(toIndentedString(tuple)).append("\n");
    sb.append("    attribute: ").append(toIndentedString(attribute)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `operation` to the URL query string
    if (getOperation() != null) {
      joiner.add(String.format("%soperation%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getOperation()))));
    }

    // add `tuple` to the URL query string
    if (getTuple() != null) {
      joiner.add(getTuple().toUrlQueryString(prefix + "tuple" + suffix));
    }

    // add `attribute` to the URL query string
    if (getAttribute() != null) {
      joiner.add(getAttribute().toUrlQueryString(prefix + "attribute" + suffix));
    }

    return joiner.toString();
  }
}

