/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.0.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.DataChange;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import co.permify.sdk.client.ApiClient;
/**
 * DataChanges represent changes in data with a snap token and a list of data change objects.
 */
@JsonPropertyOrder({
  DataChanges.JSON_PROPERTY_SNAP_TOKEN,
  DataChanges.JSON_PROPERTY_DATA_CHANGES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.14.0")
public class DataChanges {
  public static final String JSON_PROPERTY_SNAP_TOKEN = "snap_token";
  @jakarta.annotation.Nullable
  private String snapToken;

  public static final String JSON_PROPERTY_DATA_CHANGES = "data_changes";
  @jakarta.annotation.Nullable
  private List<DataChange> dataChanges = new ArrayList<>();

  public DataChanges() { 
  }

  public DataChanges snapToken(@jakarta.annotation.Nullable String snapToken) {
    this.snapToken = snapToken;
    return this;
  }

  /**
   * The snapshot token.
   * @return snapToken
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SNAP_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSnapToken() {
    return snapToken;
  }


  @JsonProperty(JSON_PROPERTY_SNAP_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSnapToken(@jakarta.annotation.Nullable String snapToken) {
    this.snapToken = snapToken;
  }


  public DataChanges dataChanges(@jakarta.annotation.Nullable List<DataChange> dataChanges) {
    this.dataChanges = dataChanges;
    return this;
  }

  public DataChanges addDataChangesItem(DataChange dataChangesItem) {
    if (this.dataChanges == null) {
      this.dataChanges = new ArrayList<>();
    }
    this.dataChanges.add(dataChangesItem);
    return this;
  }

  /**
   * The list of data changes.
   * @return dataChanges
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATA_CHANGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<DataChange> getDataChanges() {
    return dataChanges;
  }


  @JsonProperty(JSON_PROPERTY_DATA_CHANGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataChanges(@jakarta.annotation.Nullable List<DataChange> dataChanges) {
    this.dataChanges = dataChanges;
  }


  /**
   * Return true if this DataChanges object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataChanges dataChanges = (DataChanges) o;
    return Objects.equals(this.snapToken, dataChanges.snapToken) &&
        Objects.equals(this.dataChanges, dataChanges.dataChanges);
  }

  @Override
  public int hashCode() {
    return Objects.hash(snapToken, dataChanges);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataChanges {\n");
    sb.append("    snapToken: ").append(toIndentedString(snapToken)).append("\n");
    sb.append("    dataChanges: ").append(toIndentedString(dataChanges)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `snap_token` to the URL query string
    if (getSnapToken() != null) {
      joiner.add(String.format("%ssnap_token%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getSnapToken()))));
    }

    // add `data_changes` to the URL query string
    if (getDataChanges() != null) {
      for (int i = 0; i < getDataChanges().size(); i++) {
        if (getDataChanges().get(i) != null) {
          joiner.add(getDataChanges().get(i).toUrlQueryString(String.format("%sdata_changes%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

