/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.0.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Attribute;
import co.permify.sdk.model.DataWriteRequestMetadata;
import co.permify.sdk.model.Tuple;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import co.permify.sdk.client.ApiClient;
/**
 * DataWriteRequest defines the structure of a request for writing data. It contains the necessary information such as tenant_id, metadata, tuples and attributes for the write operation.
 */
@JsonPropertyOrder({
  DataWriteBody.JSON_PROPERTY_METADATA,
  DataWriteBody.JSON_PROPERTY_TUPLES,
  DataWriteBody.JSON_PROPERTY_ATTRIBUTES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.14.0")
public class DataWriteBody {
  public static final String JSON_PROPERTY_METADATA = "metadata";
  @jakarta.annotation.Nullable
  private DataWriteRequestMetadata metadata;

  public static final String JSON_PROPERTY_TUPLES = "tuples";
  @jakarta.annotation.Nullable
  private List<Tuple> tuples = new ArrayList<>();

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  @jakarta.annotation.Nullable
  private List<Attribute> attributes = new ArrayList<>();

  public DataWriteBody() { 
  }

  public DataWriteBody metadata(@jakarta.annotation.Nullable DataWriteRequestMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Get metadata
   * @return metadata
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DataWriteRequestMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(@jakarta.annotation.Nullable DataWriteRequestMetadata metadata) {
    this.metadata = metadata;
  }


  public DataWriteBody tuples(@jakarta.annotation.Nullable List<Tuple> tuples) {
    this.tuples = tuples;
    return this;
  }

  public DataWriteBody addTuplesItem(Tuple tuplesItem) {
    if (this.tuples == null) {
      this.tuples = new ArrayList<>();
    }
    this.tuples.add(tuplesItem);
    return this;
  }

  /**
   * tuples contains the list of tuples (entity-relation-entity triples) that need to be written.
   * @return tuples
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TUPLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Tuple> getTuples() {
    return tuples;
  }


  @JsonProperty(JSON_PROPERTY_TUPLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTuples(@jakarta.annotation.Nullable List<Tuple> tuples) {
    this.tuples = tuples;
  }


  public DataWriteBody attributes(@jakarta.annotation.Nullable List<Attribute> attributes) {
    this.attributes = attributes;
    return this;
  }

  public DataWriteBody addAttributesItem(Attribute attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

  /**
   * attributes contains the list of attributes (entity-attribute-value triples) that need to be written.
   * @return attributes
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Attribute> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(@jakarta.annotation.Nullable List<Attribute> attributes) {
    this.attributes = attributes;
  }


  /**
   * Return true if this Data.WriteBody object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataWriteBody dataWriteBody = (DataWriteBody) o;
    return Objects.equals(this.metadata, dataWriteBody.metadata) &&
        Objects.equals(this.tuples, dataWriteBody.tuples) &&
        Objects.equals(this.attributes, dataWriteBody.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metadata, tuples, attributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataWriteBody {\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    tuples: ").append(toIndentedString(tuples)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `metadata` to the URL query string
    if (getMetadata() != null) {
      joiner.add(getMetadata().toUrlQueryString(prefix + "metadata" + suffix));
    }

    // add `tuples` to the URL query string
    if (getTuples() != null) {
      for (int i = 0; i < getTuples().size(); i++) {
        if (getTuples().get(i) != null) {
          joiner.add(getTuples().get(i).toUrlQueryString(String.format("%stuples%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `attributes` to the URL query string
    if (getAttributes() != null) {
      for (int i = 0; i < getAttributes().size(); i++) {
        if (getAttributes().get(i) != null) {
          joiner.add(getAttributes().get(i).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

