/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.0.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import co.permify.sdk.client.ApiClient;
/**
 * Represents an entry.
 */
@JsonPropertyOrder({
  Entry.JSON_PROPERTY_ID,
  Entry.JSON_PROPERTY_FIELD_KEY,
  Entry.JSON_PROPERTY_MAP_KEY,
  Entry.JSON_PROPERTY_VALUE,
  Entry.JSON_PROPERTY_OPTIONAL_ENTRY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.14.0")
public class Entry {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_FIELD_KEY = "fieldKey";
  @jakarta.annotation.Nullable
  private String fieldKey;

  public static final String JSON_PROPERTY_MAP_KEY = "mapKey";
  @jakarta.annotation.Nullable
  private Object mapKey;

  public static final String JSON_PROPERTY_VALUE = "value";
  @jakarta.annotation.Nullable
  private Object value;

  public static final String JSON_PROPERTY_OPTIONAL_ENTRY = "optionalEntry";
  @jakarta.annotation.Nullable
  private Boolean optionalEntry;

  public Entry() { 
  }

  public Entry id(@jakarta.annotation.Nullable String id) {
    this.id = id;
    return this;
  }

  /**
   * Required. An id assigned to this node by the parser which is unique in a given expression tree. This is used to associate type information and other attributes to the node.
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }


  public Entry fieldKey(@jakarta.annotation.Nullable String fieldKey) {
    this.fieldKey = fieldKey;
    return this;
  }

  /**
   * The field key for a message creator statement.
   * @return fieldKey
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIELD_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFieldKey() {
    return fieldKey;
  }


  @JsonProperty(JSON_PROPERTY_FIELD_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFieldKey(@jakarta.annotation.Nullable String fieldKey) {
    this.fieldKey = fieldKey;
  }


  public Entry mapKey(@jakarta.annotation.Nullable Object mapKey) {
    this.mapKey = mapKey;
    return this;
  }

  /**
   * An abstract representation of a common expression.  Expressions are abstractly represented as a collection of identifiers, select statements, function calls, literals, and comprehensions. All operators with the exception of the &#39;.&#39; operator are modelled as function calls. This makes it easy to represent new operators into the existing AST.  All references within expressions must resolve to a [Decl][google.api.expr.v1alpha1.Decl] provided at type-check for an expression to be valid. A reference may either be a bare identifier &#x60;name&#x60; or a qualified identifier &#x60;google.api.name&#x60;. References may either refer to a value or a function declaration.  For example, the expression &#x60;google.api.name.startsWith(&#39;expr&#39;)&#x60; references the declaration &#x60;google.api.name&#x60; within a [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression, and the function declaration &#x60;startsWith&#x60;.
   * @return mapKey
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Object getMapKey() {
    return mapKey;
  }


  @JsonProperty(JSON_PROPERTY_MAP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMapKey(@jakarta.annotation.Nullable Object mapKey) {
    this.mapKey = mapKey;
  }


  public Entry value(@jakarta.annotation.Nullable Object value) {
    this.value = value;
    return this;
  }

  /**
   * An abstract representation of a common expression.  Expressions are abstractly represented as a collection of identifiers, select statements, function calls, literals, and comprehensions. All operators with the exception of the &#39;.&#39; operator are modelled as function calls. This makes it easy to represent new operators into the existing AST.  All references within expressions must resolve to a [Decl][google.api.expr.v1alpha1.Decl] provided at type-check for an expression to be valid. A reference may either be a bare identifier &#x60;name&#x60; or a qualified identifier &#x60;google.api.name&#x60;. References may either refer to a value or a function declaration.  For example, the expression &#x60;google.api.name.startsWith(&#39;expr&#39;)&#x60; references the declaration &#x60;google.api.name&#x60; within a [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression, and the function declaration &#x60;startsWith&#x60;.
   * @return value
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Object getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(@jakarta.annotation.Nullable Object value) {
    this.value = value;
  }


  public Entry optionalEntry(@jakarta.annotation.Nullable Boolean optionalEntry) {
    this.optionalEntry = optionalEntry;
    return this;
  }

  /**
   * Whether the key-value pair is optional.
   * @return optionalEntry
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPTIONAL_ENTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getOptionalEntry() {
    return optionalEntry;
  }


  @JsonProperty(JSON_PROPERTY_OPTIONAL_ENTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOptionalEntry(@jakarta.annotation.Nullable Boolean optionalEntry) {
    this.optionalEntry = optionalEntry;
  }


  /**
   * Return true if this Entry object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Entry entry = (Entry) o;
    return Objects.equals(this.id, entry.id) &&
        Objects.equals(this.fieldKey, entry.fieldKey) &&
        Objects.equals(this.mapKey, entry.mapKey) &&
        Objects.equals(this.value, entry.value) &&
        Objects.equals(this.optionalEntry, entry.optionalEntry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, fieldKey, mapKey, value, optionalEntry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Entry {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    fieldKey: ").append(toIndentedString(fieldKey)).append("\n");
    sb.append("    mapKey: ").append(toIndentedString(mapKey)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    optionalEntry: ").append(toIndentedString(optionalEntry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getId()))));
    }

    // add `fieldKey` to the URL query string
    if (getFieldKey() != null) {
      joiner.add(String.format("%sfieldKey%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getFieldKey()))));
    }

    // add `mapKey` to the URL query string
    if (getMapKey() != null) {
      joiner.add(String.format("%smapKey%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getMapKey()))));
    }

    // add `value` to the URL query string
    if (getValue() != null) {
      joiner.add(String.format("%svalue%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getValue()))));
    }

    // add `optionalEntry` to the URL query string
    if (getOptionalEntry() != null) {
      joiner.add(String.format("%soptionalEntry%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getOptionalEntry()))));
    }

    return joiner.toString();
  }
}

