/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.0.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Context;
import co.permify.sdk.model.PermissionLookupEntityRequestMetadata;
import co.permify.sdk.model.Subject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import co.permify.sdk.client.ApiClient;
/**
 * PermissionLookupEntityRequest is the request message for the LookupEntity method in the Permission service.
 */
@JsonPropertyOrder({
  LookupEntityBody.JSON_PROPERTY_METADATA,
  LookupEntityBody.JSON_PROPERTY_ENTITY_TYPE,
  LookupEntityBody.JSON_PROPERTY_PERMISSION,
  LookupEntityBody.JSON_PROPERTY_SUBJECT,
  LookupEntityBody.JSON_PROPERTY_CONTEXT,
  LookupEntityBody.JSON_PROPERTY_PAGE_SIZE,
  LookupEntityBody.JSON_PROPERTY_CONTINUOUS_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.14.0")
public class LookupEntityBody {
  public static final String JSON_PROPERTY_METADATA = "metadata";
  @jakarta.annotation.Nullable
  private PermissionLookupEntityRequestMetadata metadata;

  public static final String JSON_PROPERTY_ENTITY_TYPE = "entity_type";
  @jakarta.annotation.Nullable
  private String entityType;

  public static final String JSON_PROPERTY_PERMISSION = "permission";
  @jakarta.annotation.Nullable
  private String permission;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  @jakarta.annotation.Nullable
  private Subject subject;

  public static final String JSON_PROPERTY_CONTEXT = "context";
  @jakarta.annotation.Nullable
  private Context context;

  public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
  @jakarta.annotation.Nullable
  private Long pageSize;

  public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
  @jakarta.annotation.Nullable
  private String continuousToken;

  public LookupEntityBody() { 
  }

  public LookupEntityBody metadata(@jakarta.annotation.Nullable PermissionLookupEntityRequestMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Get metadata
   * @return metadata
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PermissionLookupEntityRequestMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(@jakarta.annotation.Nullable PermissionLookupEntityRequestMetadata metadata) {
    this.metadata = metadata;
  }


  public LookupEntityBody entityType(@jakarta.annotation.Nullable String entityType) {
    this.entityType = entityType;
    return this;
  }

  /**
   * Type of the entity to lookup, required, must start with a letter and can include alphanumeric and underscore, max 64 bytes.
   * @return entityType
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEntityType() {
    return entityType;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntityType(@jakarta.annotation.Nullable String entityType) {
    this.entityType = entityType;
  }


  public LookupEntityBody permission(@jakarta.annotation.Nullable String permission) {
    this.permission = permission;
    return this;
  }

  /**
   * Name of the permission to check, required, must start with a letter and can include alphanumeric and underscore, max 64 bytes.
   * @return permission
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPermission() {
    return permission;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermission(@jakarta.annotation.Nullable String permission) {
    this.permission = permission;
  }


  public LookupEntityBody subject(@jakarta.annotation.Nullable Subject subject) {
    this.subject = subject;
    return this;
  }

  /**
   * Get subject
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Subject getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(@jakarta.annotation.Nullable Subject subject) {
    this.subject = subject;
  }


  public LookupEntityBody context(@jakarta.annotation.Nullable Context context) {
    this.context = context;
    return this;
  }

  /**
   * Get context
   * @return context
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Context getContext() {
    return context;
  }


  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContext(@jakarta.annotation.Nullable Context context) {
    this.context = context;
  }


  public LookupEntityBody pageSize(@jakarta.annotation.Nullable Long pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * page_size is the number of tenants to be returned in the response. The value should be between 1 and 100.
   * @return pageSize
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getPageSize() {
    return pageSize;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageSize(@jakarta.annotation.Nullable Long pageSize) {
    this.pageSize = pageSize;
  }


  public LookupEntityBody continuousToken(@jakarta.annotation.Nullable String continuousToken) {
    this.continuousToken = continuousToken;
    return this;
  }

  /**
   * continuous_token is an optional parameter used for pagination. It should be the value received in the previous response.
   * @return continuousToken
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getContinuousToken() {
    return continuousToken;
  }


  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinuousToken(@jakarta.annotation.Nullable String continuousToken) {
    this.continuousToken = continuousToken;
  }


  /**
   * Return true if this LookupEntityBody object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LookupEntityBody lookupEntityBody = (LookupEntityBody) o;
    return Objects.equals(this.metadata, lookupEntityBody.metadata) &&
        Objects.equals(this.entityType, lookupEntityBody.entityType) &&
        Objects.equals(this.permission, lookupEntityBody.permission) &&
        Objects.equals(this.subject, lookupEntityBody.subject) &&
        Objects.equals(this.context, lookupEntityBody.context) &&
        Objects.equals(this.pageSize, lookupEntityBody.pageSize) &&
        Objects.equals(this.continuousToken, lookupEntityBody.continuousToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metadata, entityType, permission, subject, context, pageSize, continuousToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LookupEntityBody {\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    permission: ").append(toIndentedString(permission)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    continuousToken: ").append(toIndentedString(continuousToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `metadata` to the URL query string
    if (getMetadata() != null) {
      joiner.add(getMetadata().toUrlQueryString(prefix + "metadata" + suffix));
    }

    // add `entity_type` to the URL query string
    if (getEntityType() != null) {
      joiner.add(String.format("%sentity_type%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getEntityType()))));
    }

    // add `permission` to the URL query string
    if (getPermission() != null) {
      joiner.add(String.format("%spermission%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getPermission()))));
    }

    // add `subject` to the URL query string
    if (getSubject() != null) {
      joiner.add(getSubject().toUrlQueryString(prefix + "subject" + suffix));
    }

    // add `context` to the URL query string
    if (getContext() != null) {
      joiner.add(getContext().toUrlQueryString(prefix + "context" + suffix));
    }

    // add `page_size` to the URL query string
    if (getPageSize() != null) {
      joiner.add(String.format("%spage_size%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getPageSize()))));
    }

    // add `continuous_token` to the URL query string
    if (getContinuousToken() != null) {
      joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getContinuousToken()))));
    }

    return joiner.toString();
  }
}

