/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.0.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import co.permify.sdk.client.ApiClient;
/**
 * A field selection expression. e.g. &#x60;request.auth&#x60;.
 */
@JsonPropertyOrder({
  Select.JSON_PROPERTY_OPERAND,
  Select.JSON_PROPERTY_FIELD,
  Select.JSON_PROPERTY_TEST_ONLY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.14.0")
public class Select {
  public static final String JSON_PROPERTY_OPERAND = "operand";
  @jakarta.annotation.Nullable
  private Object operand;

  public static final String JSON_PROPERTY_FIELD = "field";
  @jakarta.annotation.Nullable
  private String field;

  public static final String JSON_PROPERTY_TEST_ONLY = "testOnly";
  @jakarta.annotation.Nullable
  private Boolean testOnly;

  public Select() { 
  }

  public Select operand(@jakarta.annotation.Nullable Object operand) {
    this.operand = operand;
    return this;
  }

  /**
   * An abstract representation of a common expression.  Expressions are abstractly represented as a collection of identifiers, select statements, function calls, literals, and comprehensions. All operators with the exception of the &#39;.&#39; operator are modelled as function calls. This makes it easy to represent new operators into the existing AST.  All references within expressions must resolve to a [Decl][google.api.expr.v1alpha1.Decl] provided at type-check for an expression to be valid. A reference may either be a bare identifier &#x60;name&#x60; or a qualified identifier &#x60;google.api.name&#x60;. References may either refer to a value or a function declaration.  For example, the expression &#x60;google.api.name.startsWith(&#39;expr&#39;)&#x60; references the declaration &#x60;google.api.name&#x60; within a [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression, and the function declaration &#x60;startsWith&#x60;.
   * @return operand
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Object getOperand() {
    return operand;
  }


  @JsonProperty(JSON_PROPERTY_OPERAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperand(@jakarta.annotation.Nullable Object operand) {
    this.operand = operand;
  }


  public Select field(@jakarta.annotation.Nullable String field) {
    this.field = field;
    return this;
  }

  /**
   * Required. The name of the field to select.  For example, in the select expression &#x60;request.auth&#x60;, the &#x60;auth&#x60; portion of the expression would be the &#x60;field&#x60;.
   * @return field
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getField() {
    return field;
  }


  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setField(@jakarta.annotation.Nullable String field) {
    this.field = field;
  }


  public Select testOnly(@jakarta.annotation.Nullable Boolean testOnly) {
    this.testOnly = testOnly;
    return this;
  }

  /**
   * Whether the select is to be interpreted as a field presence test.  This results from the macro &#x60;has(request.auth)&#x60;.
   * @return testOnly
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEST_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getTestOnly() {
    return testOnly;
  }


  @JsonProperty(JSON_PROPERTY_TEST_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestOnly(@jakarta.annotation.Nullable Boolean testOnly) {
    this.testOnly = testOnly;
  }


  /**
   * Return true if this Select object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Select select = (Select) o;
    return Objects.equals(this.operand, select.operand) &&
        Objects.equals(this.field, select.field) &&
        Objects.equals(this.testOnly, select.testOnly);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operand, field, testOnly);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Select {\n");
    sb.append("    operand: ").append(toIndentedString(operand)).append("\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    testOnly: ").append(toIndentedString(testOnly)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `operand` to the URL query string
    if (getOperand() != null) {
      joiner.add(String.format("%soperand%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getOperand()))));
    }

    // add `field` to the URL query string
    if (getField() != null) {
      joiner.add(String.format("%sfield%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getField()))));
    }

    // add `testOnly` to the URL query string
    if (getTestOnly() != null) {
      joiner.add(String.format("%stestOnly%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getTestOnly()))));
    }

    return joiner.toString();
  }
}

