/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.0.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import co.permify.sdk.client.ApiClient;
/**
 * Source information collected at parse time.
 */
@JsonPropertyOrder({
  SourceInfo.JSON_PROPERTY_SYNTAX_VERSION,
  SourceInfo.JSON_PROPERTY_LOCATION,
  SourceInfo.JSON_PROPERTY_LINE_OFFSETS,
  SourceInfo.JSON_PROPERTY_POSITIONS,
  SourceInfo.JSON_PROPERTY_MACRO_CALLS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.14.0")
public class SourceInfo {
  public static final String JSON_PROPERTY_SYNTAX_VERSION = "syntaxVersion";
  @jakarta.annotation.Nullable
  private String syntaxVersion;

  public static final String JSON_PROPERTY_LOCATION = "location";
  @jakarta.annotation.Nullable
  private String location;

  public static final String JSON_PROPERTY_LINE_OFFSETS = "lineOffsets";
  @jakarta.annotation.Nullable
  private List<Integer> lineOffsets = new ArrayList<>();

  public static final String JSON_PROPERTY_POSITIONS = "positions";
  @jakarta.annotation.Nullable
  private Map<String, Integer> positions = new HashMap<>();

  public static final String JSON_PROPERTY_MACRO_CALLS = "macroCalls";
  @jakarta.annotation.Nullable
  private Map<String, Object> macroCalls = new HashMap<>();

  public SourceInfo() { 
  }

  public SourceInfo syntaxVersion(@jakarta.annotation.Nullable String syntaxVersion) {
    this.syntaxVersion = syntaxVersion;
    return this;
  }

  /**
   * The syntax version of the source, e.g. &#x60;cel1&#x60;.
   * @return syntaxVersion
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SYNTAX_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSyntaxVersion() {
    return syntaxVersion;
  }


  @JsonProperty(JSON_PROPERTY_SYNTAX_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSyntaxVersion(@jakarta.annotation.Nullable String syntaxVersion) {
    this.syntaxVersion = syntaxVersion;
  }


  public SourceInfo location(@jakarta.annotation.Nullable String location) {
    this.location = location;
    return this;
  }

  /**
   * The location name. All position information attached to an expression is relative to this location.  The location could be a file, UI element, or similar. For example, &#x60;acme/app/AnvilPolicy.cel&#x60;.
   * @return location
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(@jakarta.annotation.Nullable String location) {
    this.location = location;
  }


  public SourceInfo lineOffsets(@jakarta.annotation.Nullable List<Integer> lineOffsets) {
    this.lineOffsets = lineOffsets;
    return this;
  }

  public SourceInfo addLineOffsetsItem(Integer lineOffsetsItem) {
    if (this.lineOffsets == null) {
      this.lineOffsets = new ArrayList<>();
    }
    this.lineOffsets.add(lineOffsetsItem);
    return this;
  }

  /**
   * Monotonically increasing list of code point offsets where newlines &#x60;\\n&#x60; appear.  The line number of a given position is the index &#x60;i&#x60; where for a given &#x60;id&#x60; the &#x60;line_offsets[i] &lt; id_positions[id] &lt; line_offsets[i+1]&#x60;. The column may be derivd from &#x60;id_positions[id] - line_offsets[i]&#x60;.
   * @return lineOffsets
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINE_OFFSETS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Integer> getLineOffsets() {
    return lineOffsets;
  }


  @JsonProperty(JSON_PROPERTY_LINE_OFFSETS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineOffsets(@jakarta.annotation.Nullable List<Integer> lineOffsets) {
    this.lineOffsets = lineOffsets;
  }


  public SourceInfo positions(@jakarta.annotation.Nullable Map<String, Integer> positions) {
    this.positions = positions;
    return this;
  }

  public SourceInfo putPositionsItem(String key, Integer positionsItem) {
    if (this.positions == null) {
      this.positions = new HashMap<>();
    }
    this.positions.put(key, positionsItem);
    return this;
  }

  /**
   * A map from the parse node id (e.g. &#x60;Expr.id&#x60;) to the code point offset within the source.
   * @return positions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, Integer> getPositions() {
    return positions;
  }


  @JsonProperty(JSON_PROPERTY_POSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPositions(@jakarta.annotation.Nullable Map<String, Integer> positions) {
    this.positions = positions;
  }


  public SourceInfo macroCalls(@jakarta.annotation.Nullable Map<String, Object> macroCalls) {
    this.macroCalls = macroCalls;
    return this;
  }

  public SourceInfo putMacroCallsItem(String key, Object macroCallsItem) {
    if (this.macroCalls == null) {
      this.macroCalls = new HashMap<>();
    }
    this.macroCalls.put(key, macroCallsItem);
    return this;
  }

  /**
   * A map from the parse node id where a macro replacement was made to the call &#x60;Expr&#x60; that resulted in a macro expansion.  For example, &#x60;has(value.field)&#x60; is a function call that is replaced by a &#x60;test_only&#x60; field selection in the AST. Likewise, the call &#x60;list.exists(e, e &gt; 10)&#x60; translates to a comprehension expression. The key in the map corresponds to the expression id of the expanded macro, and the value is the call &#x60;Expr&#x60; that was replaced.
   * @return macroCalls
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MACRO_CALLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, Object> getMacroCalls() {
    return macroCalls;
  }


  @JsonProperty(JSON_PROPERTY_MACRO_CALLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMacroCalls(@jakarta.annotation.Nullable Map<String, Object> macroCalls) {
    this.macroCalls = macroCalls;
  }


  /**
   * Return true if this SourceInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SourceInfo sourceInfo = (SourceInfo) o;
    return Objects.equals(this.syntaxVersion, sourceInfo.syntaxVersion) &&
        Objects.equals(this.location, sourceInfo.location) &&
        Objects.equals(this.lineOffsets, sourceInfo.lineOffsets) &&
        Objects.equals(this.positions, sourceInfo.positions) &&
        Objects.equals(this.macroCalls, sourceInfo.macroCalls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(syntaxVersion, location, lineOffsets, positions, macroCalls);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SourceInfo {\n");
    sb.append("    syntaxVersion: ").append(toIndentedString(syntaxVersion)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    lineOffsets: ").append(toIndentedString(lineOffsets)).append("\n");
    sb.append("    positions: ").append(toIndentedString(positions)).append("\n");
    sb.append("    macroCalls: ").append(toIndentedString(macroCalls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `syntaxVersion` to the URL query string
    if (getSyntaxVersion() != null) {
      joiner.add(String.format("%ssyntaxVersion%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getSyntaxVersion()))));
    }

    // add `location` to the URL query string
    if (getLocation() != null) {
      joiner.add(String.format("%slocation%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(getLocation()))));
    }

    // add `lineOffsets` to the URL query string
    if (getLineOffsets() != null) {
      for (int i = 0; i < getLineOffsets().size(); i++) {
        joiner.add(String.format("%slineOffsets%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            ApiClient.urlEncode(ApiClient.valueToString(getLineOffsets().get(i)))));
      }
    }

    // add `positions` to the URL query string
    if (getPositions() != null) {
      for (String _key : getPositions().keySet()) {
        joiner.add(String.format("%spositions%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getPositions().get(_key), ApiClient.urlEncode(ApiClient.valueToString(getPositions().get(_key)))));
      }
    }

    // add `macroCalls` to the URL query string
    if (getMacroCalls() != null) {
      for (String _key : getMacroCalls().keySet()) {
        joiner.add(String.format("%smacroCalls%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getMacroCalls().get(_key), ApiClient.urlEncode(ApiClient.valueToString(getMacroCalls().get(_key)))));
      }
    }

    return joiner.toString();
  }
}

