/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.api;

import co.permify.sdk.client.ApiClient;
import co.permify.sdk.client.ApiException;
import co.permify.sdk.client.ApiResponse;
import co.permify.sdk.client.Configuration;
import co.permify.sdk.model.BundleDeleteBody;
import co.permify.sdk.model.BundleDeleteResponse;
import co.permify.sdk.model.BundleReadBody;
import co.permify.sdk.model.BundleReadResponse;
import co.permify.sdk.model.BundleWriteBody;
import co.permify.sdk.model.BundleWriteResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

public class BundleApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public BundleApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BundleApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public BundleDeleteResponse bundleDelete(@Nonnull String tenantId, @Nonnull BundleDeleteBody body) throws ApiException {
        ApiResponse<BundleDeleteResponse> localVarResponse = this.bundleDeleteWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<BundleDeleteResponse> bundleDeleteWithHttpInfo(@Nonnull String tenantId, @Nonnull BundleDeleteBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.bundleDeleteRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("bundleDelete", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (BundleDeleteResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<BundleDeleteResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder bundleDeleteRequestBuilder(@Nonnull String tenantId, @Nonnull BundleDeleteBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling bundleDelete");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling bundleDelete");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/bundle/delete".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public BundleReadResponse bundleRead(@Nonnull String tenantId, @Nonnull BundleReadBody body) throws ApiException {
        ApiResponse<BundleReadResponse> localVarResponse = this.bundleReadWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<BundleReadResponse> bundleReadWithHttpInfo(@Nonnull String tenantId, @Nonnull BundleReadBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.bundleReadRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("bundleRead", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (BundleReadResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<BundleReadResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder bundleReadRequestBuilder(@Nonnull String tenantId, @Nonnull BundleReadBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling bundleRead");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling bundleRead");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/bundle/read".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public BundleWriteResponse bundleWrite(@Nonnull String tenantId, @Nonnull BundleWriteBody body) throws ApiException {
        ApiResponse<BundleWriteResponse> localVarResponse = this.bundleWriteWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<BundleWriteResponse> bundleWriteWithHttpInfo(@Nonnull String tenantId, @Nonnull BundleWriteBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.bundleWriteRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("bundleWrite", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (BundleWriteResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<BundleWriteResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder bundleWriteRequestBuilder(@Nonnull String tenantId, @Nonnull BundleWriteBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling bundleWrite");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling bundleWrite");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/bundle/write".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

