/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.api;

import co.permify.sdk.client.ApiClient;
import co.permify.sdk.client.ApiException;
import co.permify.sdk.client.ApiResponse;
import co.permify.sdk.client.Configuration;
import co.permify.sdk.model.AttributeReadResponse;
import co.permify.sdk.model.BundleRunResponse;
import co.permify.sdk.model.DataDeleteBody;
import co.permify.sdk.model.DataDeleteResponse;
import co.permify.sdk.model.DataWriteBody;
import co.permify.sdk.model.DataWriteResponse;
import co.permify.sdk.model.DeleteRelationshipsBody;
import co.permify.sdk.model.ReadAttributesBody;
import co.permify.sdk.model.ReadRelationshipsBody;
import co.permify.sdk.model.RelationshipDeleteResponse;
import co.permify.sdk.model.RelationshipReadResponse;
import co.permify.sdk.model.RelationshipWriteResponse;
import co.permify.sdk.model.RunBundleBody;
import co.permify.sdk.model.WriteRelationshipsBody;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

public class DataApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public DataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public BundleRunResponse bundleRun(@Nonnull String tenantId, @Nonnull RunBundleBody body) throws ApiException {
        ApiResponse<BundleRunResponse> localVarResponse = this.bundleRunWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<BundleRunResponse> bundleRunWithHttpInfo(@Nonnull String tenantId, @Nonnull RunBundleBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.bundleRunRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("bundleRun", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (BundleRunResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<BundleRunResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder bundleRunRequestBuilder(@Nonnull String tenantId, @Nonnull RunBundleBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling bundleRun");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling bundleRun");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/data/run-bundle".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public AttributeReadResponse dataAttributesRead(@Nonnull String tenantId, @Nonnull ReadAttributesBody body) throws ApiException {
        ApiResponse<AttributeReadResponse> localVarResponse = this.dataAttributesReadWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<AttributeReadResponse> dataAttributesReadWithHttpInfo(@Nonnull String tenantId, @Nonnull ReadAttributesBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.dataAttributesReadRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("dataAttributesRead", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (AttributeReadResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<AttributeReadResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder dataAttributesReadRequestBuilder(@Nonnull String tenantId, @Nonnull ReadAttributesBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling dataAttributesRead");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling dataAttributesRead");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/data/attributes/read".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public DataDeleteResponse dataDelete(@Nonnull String tenantId, @Nonnull DataDeleteBody body) throws ApiException {
        ApiResponse<DataDeleteResponse> localVarResponse = this.dataDeleteWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<DataDeleteResponse> dataDeleteWithHttpInfo(@Nonnull String tenantId, @Nonnull DataDeleteBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.dataDeleteRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("dataDelete", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (DataDeleteResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<DataDeleteResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder dataDeleteRequestBuilder(@Nonnull String tenantId, @Nonnull DataDeleteBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling dataDelete");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling dataDelete");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/data/delete".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public RelationshipReadResponse dataRelationshipsRead(@Nonnull String tenantId, @Nonnull ReadRelationshipsBody body) throws ApiException {
        ApiResponse<RelationshipReadResponse> localVarResponse = this.dataRelationshipsReadWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<RelationshipReadResponse> dataRelationshipsReadWithHttpInfo(@Nonnull String tenantId, @Nonnull ReadRelationshipsBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.dataRelationshipsReadRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("dataRelationshipsRead", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (RelationshipReadResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<RelationshipReadResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder dataRelationshipsReadRequestBuilder(@Nonnull String tenantId, @Nonnull ReadRelationshipsBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling dataRelationshipsRead");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling dataRelationshipsRead");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/data/relationships/read".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public DataWriteResponse dataWrite(@Nonnull String tenantId, @Nonnull DataWriteBody body) throws ApiException {
        ApiResponse<DataWriteResponse> localVarResponse = this.dataWriteWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<DataWriteResponse> dataWriteWithHttpInfo(@Nonnull String tenantId, @Nonnull DataWriteBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.dataWriteRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("dataWrite", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (DataWriteResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<DataWriteResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder dataWriteRequestBuilder(@Nonnull String tenantId, @Nonnull DataWriteBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling dataWrite");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling dataWrite");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/data/write".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public RelationshipDeleteResponse relationshipsDelete(@Nonnull String tenantId, @Nonnull DeleteRelationshipsBody body) throws ApiException {
        ApiResponse<RelationshipDeleteResponse> localVarResponse = this.relationshipsDeleteWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<RelationshipDeleteResponse> relationshipsDeleteWithHttpInfo(@Nonnull String tenantId, @Nonnull DeleteRelationshipsBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.relationshipsDeleteRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("relationshipsDelete", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (RelationshipDeleteResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<RelationshipDeleteResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder relationshipsDeleteRequestBuilder(@Nonnull String tenantId, @Nonnull DeleteRelationshipsBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling relationshipsDelete");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling relationshipsDelete");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/relationships/delete".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public RelationshipWriteResponse relationshipsWrite(@Nonnull String tenantId, @Nonnull WriteRelationshipsBody body) throws ApiException {
        ApiResponse<RelationshipWriteResponse> localVarResponse = this.relationshipsWriteWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<RelationshipWriteResponse> relationshipsWriteWithHttpInfo(@Nonnull String tenantId, @Nonnull WriteRelationshipsBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.relationshipsWriteRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("relationshipsWrite", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (RelationshipWriteResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<RelationshipWriteResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder relationshipsWriteRequestBuilder(@Nonnull String tenantId, @Nonnull WriteRelationshipsBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling relationshipsWrite");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling relationshipsWrite");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/relationships/write".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

