/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.api;

import co.permify.sdk.client.ApiClient;
import co.permify.sdk.client.ApiException;
import co.permify.sdk.client.ApiResponse;
import co.permify.sdk.client.Configuration;
import co.permify.sdk.model.LookupEntityBody;
import co.permify.sdk.model.LookupEntityStreamBody;
import co.permify.sdk.model.LookupSubjectBody;
import co.permify.sdk.model.PermissionCheckBody;
import co.permify.sdk.model.PermissionCheckResponse;
import co.permify.sdk.model.PermissionExpandBody;
import co.permify.sdk.model.PermissionExpandResponse;
import co.permify.sdk.model.PermissionLookupEntityResponse;
import co.permify.sdk.model.PermissionLookupSubjectResponse;
import co.permify.sdk.model.PermissionSubjectPermissionResponse;
import co.permify.sdk.model.StreamResultOfPermissionLookupEntityStreamResponse;
import co.permify.sdk.model.SubjectPermissionBody;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

public class PermissionApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public PermissionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PermissionApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public PermissionCheckResponse permissionsCheck(@Nonnull String tenantId, @Nonnull PermissionCheckBody body) throws ApiException {
        ApiResponse<PermissionCheckResponse> localVarResponse = this.permissionsCheckWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<PermissionCheckResponse> permissionsCheckWithHttpInfo(@Nonnull String tenantId, @Nonnull PermissionCheckBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.permissionsCheckRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("permissionsCheck", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (PermissionCheckResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PermissionCheckResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder permissionsCheckRequestBuilder(@Nonnull String tenantId, @Nonnull PermissionCheckBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsCheck");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsCheck");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/permissions/check".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PermissionExpandResponse permissionsExpand(@Nonnull String tenantId, @Nonnull PermissionExpandBody body) throws ApiException {
        ApiResponse<PermissionExpandResponse> localVarResponse = this.permissionsExpandWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<PermissionExpandResponse> permissionsExpandWithHttpInfo(@Nonnull String tenantId, @Nonnull PermissionExpandBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.permissionsExpandRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("permissionsExpand", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (PermissionExpandResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PermissionExpandResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder permissionsExpandRequestBuilder(@Nonnull String tenantId, @Nonnull PermissionExpandBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsExpand");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsExpand");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/permissions/expand".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PermissionLookupEntityResponse permissionsLookupEntity(@Nonnull String tenantId, @Nonnull LookupEntityBody body) throws ApiException {
        ApiResponse<PermissionLookupEntityResponse> localVarResponse = this.permissionsLookupEntityWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<PermissionLookupEntityResponse> permissionsLookupEntityWithHttpInfo(@Nonnull String tenantId, @Nonnull LookupEntityBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.permissionsLookupEntityRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("permissionsLookupEntity", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (PermissionLookupEntityResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PermissionLookupEntityResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder permissionsLookupEntityRequestBuilder(@Nonnull String tenantId, @Nonnull LookupEntityBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsLookupEntity");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsLookupEntity");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/permissions/lookup-entity".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public StreamResultOfPermissionLookupEntityStreamResponse permissionsLookupEntityStream(@Nonnull String tenantId, @Nonnull LookupEntityStreamBody body) throws ApiException {
        ApiResponse<StreamResultOfPermissionLookupEntityStreamResponse> localVarResponse = this.permissionsLookupEntityStreamWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<StreamResultOfPermissionLookupEntityStreamResponse> permissionsLookupEntityStreamWithHttpInfo(@Nonnull String tenantId, @Nonnull LookupEntityStreamBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.permissionsLookupEntityStreamRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("permissionsLookupEntityStream", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (StreamResultOfPermissionLookupEntityStreamResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<StreamResultOfPermissionLookupEntityStreamResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder permissionsLookupEntityStreamRequestBuilder(@Nonnull String tenantId, @Nonnull LookupEntityStreamBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsLookupEntityStream");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsLookupEntityStream");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/permissions/lookup-entity-stream".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PermissionLookupSubjectResponse permissionsLookupSubject(@Nonnull String tenantId, @Nonnull LookupSubjectBody body) throws ApiException {
        ApiResponse<PermissionLookupSubjectResponse> localVarResponse = this.permissionsLookupSubjectWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<PermissionLookupSubjectResponse> permissionsLookupSubjectWithHttpInfo(@Nonnull String tenantId, @Nonnull LookupSubjectBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.permissionsLookupSubjectRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("permissionsLookupSubject", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (PermissionLookupSubjectResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PermissionLookupSubjectResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder permissionsLookupSubjectRequestBuilder(@Nonnull String tenantId, @Nonnull LookupSubjectBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsLookupSubject");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsLookupSubject");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/permissions/lookup-subject".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PermissionSubjectPermissionResponse permissionsSubjectPermission(@Nonnull String tenantId, @Nonnull SubjectPermissionBody body) throws ApiException {
        ApiResponse<PermissionSubjectPermissionResponse> localVarResponse = this.permissionsSubjectPermissionWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<PermissionSubjectPermissionResponse> permissionsSubjectPermissionWithHttpInfo(@Nonnull String tenantId, @Nonnull SubjectPermissionBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.permissionsSubjectPermissionRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("permissionsSubjectPermission", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (PermissionSubjectPermissionResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PermissionSubjectPermissionResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder permissionsSubjectPermissionRequestBuilder(@Nonnull String tenantId, @Nonnull SubjectPermissionBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsSubjectPermission");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsSubjectPermission");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/permissions/subject-permission".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

