/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.api;

import co.permify.sdk.client.ApiClient;
import co.permify.sdk.client.ApiException;
import co.permify.sdk.client.ApiResponse;
import co.permify.sdk.client.Configuration;
import co.permify.sdk.model.PartialWriteBody;
import co.permify.sdk.model.SchemaListBody;
import co.permify.sdk.model.SchemaListResponse;
import co.permify.sdk.model.SchemaPartialWriteResponse;
import co.permify.sdk.model.SchemaReadBody;
import co.permify.sdk.model.SchemaReadResponse;
import co.permify.sdk.model.SchemaWriteBody;
import co.permify.sdk.model.SchemaWriteResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

public class SchemaApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public SchemaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SchemaApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public SchemaListResponse schemasList(@Nonnull String tenantId, @Nonnull SchemaListBody body) throws ApiException {
        ApiResponse<SchemaListResponse> localVarResponse = this.schemasListWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<SchemaListResponse> schemasListWithHttpInfo(@Nonnull String tenantId, @Nonnull SchemaListBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.schemasListRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("schemasList", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (SchemaListResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SchemaListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder schemasListRequestBuilder(@Nonnull String tenantId, @Nonnull SchemaListBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling schemasList");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling schemasList");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/schemas/list".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public SchemaPartialWriteResponse schemasPartialWrite(@Nonnull String tenantId, @Nonnull PartialWriteBody body) throws ApiException {
        ApiResponse<SchemaPartialWriteResponse> localVarResponse = this.schemasPartialWriteWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<SchemaPartialWriteResponse> schemasPartialWriteWithHttpInfo(@Nonnull String tenantId, @Nonnull PartialWriteBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.schemasPartialWriteRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("schemasPartialWrite", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (SchemaPartialWriteResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SchemaPartialWriteResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder schemasPartialWriteRequestBuilder(@Nonnull String tenantId, @Nonnull PartialWriteBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling schemasPartialWrite");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling schemasPartialWrite");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/schemas/partial-write".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public SchemaReadResponse schemasRead(@Nonnull String tenantId, @Nonnull SchemaReadBody body) throws ApiException {
        ApiResponse<SchemaReadResponse> localVarResponse = this.schemasReadWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<SchemaReadResponse> schemasReadWithHttpInfo(@Nonnull String tenantId, @Nonnull SchemaReadBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.schemasReadRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("schemasRead", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (SchemaReadResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SchemaReadResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder schemasReadRequestBuilder(@Nonnull String tenantId, @Nonnull SchemaReadBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling schemasRead");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling schemasRead");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/schemas/read".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public SchemaWriteResponse schemasWrite(@Nonnull String tenantId, @Nonnull SchemaWriteBody body) throws ApiException {
        ApiResponse<SchemaWriteResponse> localVarResponse = this.schemasWriteWithHttpInfo(tenantId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<SchemaWriteResponse> schemasWriteWithHttpInfo(@Nonnull String tenantId, @Nonnull SchemaWriteBody body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.schemasWriteRequestBuilder(tenantId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("schemasWrite", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (SchemaWriteResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SchemaWriteResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder schemasWriteRequestBuilder(@Nonnull String tenantId, @Nonnull SchemaWriteBody body) throws ApiException {
        if (tenantId == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantId' when calling schemasWrite");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling schemasWrite");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{tenant_id}/schemas/write".replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

