/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.client.ApiClient;
import co.permify.sdk.model.Any;
import co.permify.sdk.model.Entity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"entity", "attribute", "value"})
public class Attribute {
    public static final String JSON_PROPERTY_ENTITY = "entity";
    @Nullable
    private Entity entity;
    public static final String JSON_PROPERTY_ATTRIBUTE = "attribute";
    @Nullable
    private String attribute;
    public static final String JSON_PROPERTY_VALUE = "value";
    @Nullable
    private Any value;

    public Attribute entity(@Nullable Entity entity) {
        this.entity = entity;
        return this;
    }

    @Nullable
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Entity getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntity(@Nullable Entity entity) {
        this.entity = entity;
    }

    public Attribute attribute(@Nullable String attribute) {
        this.attribute = attribute;
        return this;
    }

    @Nullable
    @JsonProperty(value="attribute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttribute() {
        return this.attribute;
    }

    @JsonProperty(value="attribute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttribute(@Nullable String attribute) {
        this.attribute = attribute;
    }

    public Attribute value(@Nullable Any value) {
        this.value = value;
        return this;
    }

    @Nullable
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Any getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(@Nullable Any value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.entity, attribute.entity) && Objects.equals(this.attribute, attribute.attribute) && Objects.equals(this.value, attribute.value);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.attribute, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attribute {\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    attribute: ").append(this.toIndentedString(this.attribute)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getEntity() != null) {
            joiner.add(this.getEntity().toUrlQueryString((String)prefix + JSON_PROPERTY_ENTITY + suffix));
        }
        if (this.getAttribute() != null) {
            joiner.add(String.format("%sattribute%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getAttribute()))));
        }
        if (this.getValue() != null) {
            joiner.add(String.format("%svalue%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getValue()))));
        }
        return joiner.toString();
    }
}

