/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.client.ApiClient;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"target", "function", "args"})
public class ExprCall {
    public static final String JSON_PROPERTY_TARGET = "target";
    @Nullable
    private Object target;
    public static final String JSON_PROPERTY_FUNCTION = "function";
    @Nullable
    private String function;
    public static final String JSON_PROPERTY_ARGS = "args";
    @Nullable
    private List<Object> args = new ArrayList<Object>();

    public ExprCall target(@Nullable Object target) {
        this.target = target;
        return this;
    }

    @Nullable
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTarget(@Nullable Object target) {
        this.target = target;
    }

    public ExprCall function(@Nullable String function) {
        this.function = function;
        return this;
    }

    @Nullable
    @JsonProperty(value="function")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFunction() {
        return this.function;
    }

    @JsonProperty(value="function")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFunction(@Nullable String function) {
        this.function = function;
    }

    public ExprCall args(@Nullable List<Object> args) {
        this.args = args;
        return this;
    }

    public ExprCall addArgsItem(Object argsItem) {
        if (this.args == null) {
            this.args = new ArrayList<Object>();
        }
        this.args.add(argsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="args")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getArgs() {
        return this.args;
    }

    @JsonProperty(value="args")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArgs(@Nullable List<Object> args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExprCall exprCall = (ExprCall)o;
        return Objects.equals(this.target, exprCall.target) && Objects.equals(this.function, exprCall.function) && Objects.equals(this.args, exprCall.args);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.function, this.args);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExprCall {\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    function: ").append(this.toIndentedString(this.function)).append("\n");
        sb.append("    args: ").append(this.toIndentedString(this.args)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTarget() != null) {
            joiner.add(String.format("%starget%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getTarget()))));
        }
        if (this.getFunction() != null) {
            joiner.add(String.format("%sfunction%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getFunction()))));
        }
        if (this.getArgs() != null) {
            for (int i = 0; i < this.getArgs().size(); ++i) {
                joiner.add(String.format("%sargs%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), ApiClient.urlEncode(ApiClient.valueToString(this.getArgs().get(i)))));
            }
        }
        return joiner.toString();
    }
}

