/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PrimitiveType {
    PRIMITIVE_TYPE_UNSPECIFIED("PRIMITIVE_TYPE_UNSPECIFIED"),
    BOOL("BOOL"),
    INT64("INT64"),
    UINT64("UINT64"),
    DOUBLE("DOUBLE"),
    STRING("STRING"),
    BYTES("BYTES");

    private String value;

    private PrimitiveType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static PrimitiveType fromValue(String value) {
        for (PrimitiveType b : PrimitiveType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

