/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.client.ApiClient;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"page_size", "continuous_token"})
public class TenantListRequest {
    public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
    @Nullable
    private Long pageSize;
    public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
    @Nullable
    private String continuousToken;

    public TenantListRequest pageSize(@Nullable Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageSize(@Nullable Long pageSize) {
        this.pageSize = pageSize;
    }

    public TenantListRequest continuousToken(@Nullable String continuousToken) {
        this.continuousToken = continuousToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="continuous_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContinuousToken() {
        return this.continuousToken;
    }

    @JsonProperty(value="continuous_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContinuousToken(@Nullable String continuousToken) {
        this.continuousToken = continuousToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantListRequest tenantListRequest = (TenantListRequest)o;
        return Objects.equals(this.pageSize, tenantListRequest.pageSize) && Objects.equals(this.continuousToken, tenantListRequest.continuousToken);
    }

    public int hashCode() {
        return Objects.hash(this.pageSize, this.continuousToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TenantListRequest {\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    continuousToken: ").append(this.toIndentedString(this.continuousToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPageSize() != null) {
            joiner.add(String.format("%spage_size%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getPageSize()))));
        }
        if (this.getContinuousToken() != null) {
            joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getContinuousToken()))));
        }
        return joiner.toString();
    }
}

